/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.compute.wasm;

import java.util.List;
import java.util.Objects;
import org.apache.ignite3.compute.JobDescriptor;
import org.apache.ignite3.compute.JobExecutionOptions;
import org.apache.ignite3.compute.JobExecutorType;
import org.apache.ignite3.compute.wasm.WasmCallingConvention;
import org.apache.ignite3.compute.wasm.WasmType;
import org.apache.ignite3.deployment.DeploymentUnit;
import org.apache.ignite3.lang.IgniteExperimental;
import org.apache.ignite3.marshalling.Marshaller;

@IgniteExperimental
public class WasmJobDescriptor {
    public static <T, R> Builder<T, R> builder(String wasmModuleFileName, String wasmFunctionName, WasmType resultType) {
        return new Builder(wasmModuleFileName, wasmFunctionName, resultType);
    }

    public static <T> Builder<T, String> commandBuilder(String wasmModuleFileName) {
        return new Builder(wasmModuleFileName, "", WasmType.STRING).callingConvention(WasmCallingConvention.GENERIC_COMMAND);
    }

    public static JobExecutionOptions.Builder optionsBuilder() {
        return JobExecutionOptions.builder().executorType(JobExecutorType.WASM_EMBEDDED);
    }

    public static class Builder<T, R> {
        private final String wasmModuleFileName;
        private final String wasmFunctionName;
        private final WasmType resultType;
        private WasmCallingConvention callingConvention = WasmCallingConvention.GENERIC;
        private List<DeploymentUnit> units;
        private JobExecutionOptions options;
        private Marshaller<T, byte[]> argumentMarshaller;
        private Marshaller<R, byte[]> resultMarshaller;

        private Builder(String wasmModuleFileName, String wasmFunctionName, WasmType resultType) {
            Objects.requireNonNull(wasmModuleFileName);
            Objects.requireNonNull(wasmFunctionName);
            Objects.requireNonNull(resultType);
            this.wasmModuleFileName = wasmModuleFileName;
            this.wasmFunctionName = wasmFunctionName;
            this.resultType = resultType;
        }

        public Builder<T, R> units(List<DeploymentUnit> units) {
            this.units = units;
            return this;
        }

        public Builder<T, R> units(DeploymentUnit ... units) {
            this.units = List.of(units);
            return this;
        }

        public Builder<T, R> options(JobExecutionOptions options) {
            this.options = options;
            return this;
        }

        public Builder<T, R> argumentMarshaller(Marshaller<T, byte[]> marshaller) {
            this.argumentMarshaller = marshaller;
            return this;
        }

        public Builder<T, R> resultMarshaller(Marshaller<R, byte[]> marshaller) {
            this.resultMarshaller = marshaller;
            return this;
        }

        public Builder<T, R> callingConvention(WasmCallingConvention callingConvention) {
            this.callingConvention = callingConvention;
            return this;
        }

        public JobDescriptor<T, R> build() {
            JobExecutionOptions opts = this.options;
            if (opts == null) {
                opts = WasmJobDescriptor.optionsBuilder().build();
            } else if (opts.executorType() != JobExecutorType.WASM_EMBEDDED) {
                throw new IllegalArgumentException("JobExecutionOptions.executorType must be WASM_EMBEDDED");
            }
            String wasmFuncDescriptor = String.format("%s:%s:%s:%s", this.wasmModuleFileName, this.wasmFunctionName, this.resultType.name(), this.callingConvention.name());
            return JobDescriptor.builder(wasmFuncDescriptor).units(this.units).options(opts).argumentMarshaller(this.argumentMarshaller).resultMarshaller(this.resultMarshaller).build();
        }
    }
}

