/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.IgniteServer;
import org.apache.ignite3.InitParameters;
import org.jetbrains.annotations.Nullable;

public class InitParametersBuilder {
    private Collection<String> metaStorageNodeNames = Collections.emptyList();
    private Collection<String> cmgNodeNames = Collections.emptyList();
    private String clusterName;
    @Nullable
    private String clusterConfiguration;
    private String license;

    public InitParametersBuilder metaStorageNodeNames(String ... metaStorageNodeNames) {
        if (metaStorageNodeNames == null) {
            throw new IllegalArgumentException("Meta storage node names cannot be null.");
        }
        this.metaStorageNodeNames = List.of(metaStorageNodeNames);
        return this;
    }

    public InitParametersBuilder metaStorageNodeNames(Collection<String> metaStorageNodeNames) {
        if (metaStorageNodeNames == null) {
            throw new IllegalArgumentException("Meta storage node names cannot be null.");
        }
        this.metaStorageNodeNames = new ArrayList<String>(metaStorageNodeNames);
        return this;
    }

    public InitParametersBuilder metaStorageNodes(IgniteServer ... metaStorageNodes) {
        if (metaStorageNodes == null) {
            throw new IllegalArgumentException("Meta storage node names cannot be null.");
        }
        this.metaStorageNodeNames = Arrays.stream(metaStorageNodes).map(IgniteServer::name).collect(Collectors.toList());
        return this;
    }

    public InitParametersBuilder metaStorageNodes(Collection<IgniteServer> metaStorageNodes) {
        if (metaStorageNodes == null) {
            throw new IllegalArgumentException("Meta storage node names cannot be null.");
        }
        this.metaStorageNodeNames = metaStorageNodes.stream().map(IgniteServer::name).collect(Collectors.toList());
        return this;
    }

    public InitParametersBuilder cmgNodeNames(String ... cmgNodeNames) {
        if (cmgNodeNames == null) {
            throw new IllegalArgumentException("CMG node names cannot be null.");
        }
        this.cmgNodeNames = List.of(cmgNodeNames);
        return this;
    }

    public InitParametersBuilder cmgNodeNames(Collection<String> cmgNodeNames) {
        if (cmgNodeNames == null) {
            throw new IllegalArgumentException("CMG node names cannot be null.");
        }
        this.cmgNodeNames = new ArrayList<String>(cmgNodeNames);
        return this;
    }

    public InitParametersBuilder cmgNodes(IgniteServer ... cmgNodes) {
        if (cmgNodes == null) {
            throw new IllegalArgumentException("CMG node names cannot be null.");
        }
        this.cmgNodeNames = Arrays.stream(cmgNodes).map(IgniteServer::name).collect(Collectors.toList());
        return this;
    }

    public InitParametersBuilder cmgNodes(Collection<IgniteServer> cmgNodes) {
        if (cmgNodes == null) {
            throw new IllegalArgumentException("CMG node names cannot be null.");
        }
        this.cmgNodeNames = cmgNodes.stream().map(IgniteServer::name).collect(Collectors.toList());
        return this;
    }

    public InitParametersBuilder clusterName(String clusterName) {
        if (clusterName == null || clusterName.isBlank()) {
            throw new IllegalArgumentException("Cluster name cannot be null or empty.");
        }
        this.clusterName = clusterName;
        return this;
    }

    public InitParametersBuilder clusterConfiguration(@Nullable String clusterConfiguration) {
        this.clusterConfiguration = clusterConfiguration;
        return this;
    }

    public InitParametersBuilder appendClusterConfiguration(String clusterConfiguration) {
        this.clusterConfiguration = this.clusterConfiguration == null ? clusterConfiguration : this.clusterConfiguration + System.lineSeparator() + clusterConfiguration;
        return this;
    }

    public InitParametersBuilder license(String license) {
        this.license = license;
        return this;
    }

    public InitParameters build() {
        if (this.clusterName == null) {
            throw new IllegalStateException("Cluster name is not set.");
        }
        return new InitParameters(this.metaStorageNodeNames, this.cmgNodeNames, this.clusterName, this.clusterConfiguration, this.license);
    }
}

