/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.table;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.cache.Cache;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.sql.SqlCommon;
import org.apache.ignite3.internal.table.IgniteTablesInternal;
import org.apache.ignite3.internal.table.StreamerReceiverRunner;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.Table;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.gridgain.internal.table.TableViewWrapper;
import org.jetbrains.annotations.Nullable;

public class InternalTablesWrapper
implements IgniteTablesInternal {
    private static final Privilege READ_SCHEMA_PRIVILEGE = Privilege.builder().action(Action.READ_SCHEMA).selector(Selector.schema(SqlCommon.DEFAULT_SCHEMA_NAME)).build();
    private final IgniteTablesInternal delegate;
    private final Authorizer authorizer;

    public InternalTablesWrapper(IgniteTablesInternal delegate, Authorizer authorizer) {
        this.delegate = delegate;
        this.authorizer = authorizer;
    }

    @Override
    public List<Table> tables() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<List<Table>> tablesAsync() {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, this.delegate::tablesAsync);
    }

    @Override
    public Table table(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TableViewInternal table(int id) throws NodeStoppingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Table> tableAsync(QualifiedName name) {
        return this.tableViewAsync(name).thenApply(res -> res);
    }

    @Override
    public CompletableFuture<TableViewInternal> tableAsync(int id) throws NodeStoppingException {
        SecurityContext context = SecurityContextHolder.getOrThrow();
        return this.delegate.tableAsync(id).thenApply(table -> table != null ? new TableViewWrapper((TableViewInternal)table, this.authorizer, context) : null);
    }

    @Override
    public TableViewInternal tableView(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<TableViewInternal> tableViewAsync(QualifiedName name) {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> {
            SecurityContext context = SecurityContextHolder.getOrNull();
            return this.delegate.tableViewAsync(name).thenApply(table -> table != null ? new TableViewWrapper((TableViewInternal)table, this.authorizer, context) : null);
        });
    }

    @Override
    public List<Cache> caches() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<List<Cache>> cachesAsync() {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, this.delegate::cachesAsync);
    }

    @Override
    public Cache cache(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Cache cache(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Cache> cacheAsync(String name) {
        return this.tableViewAsync(QualifiedName.parse(name)).thenApply(res -> res);
    }

    @Override
    public CompletableFuture<Cache> cacheAsync(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public TableViewInternal cachedTable(int tableId) {
        SecurityContext context = SecurityContextHolder.getOrThrow();
        TableViewInternal cachedTable = this.delegate.cachedTable(tableId);
        return cachedTable == null ? null : new TableViewWrapper(cachedTable, this.authorizer, context);
    }

    @Override
    public void setStreamerReceiverRunner(StreamerReceiverRunner runner) {
        this.delegate.setStreamerReceiverRunner(runner);
    }
}

