/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.util.Static;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopyLocationTable;
import org.apache.ignite3.internal.table.TableImpl;
import org.apache.ignite3.internal.table.distributed.TableManager;
import org.apache.ignite3.lang.Cursor;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;
import org.apache.ignite3.table.Table;
import org.apache.ignite3.table.Tuple;
import org.gridgain.internal.sql.copy.Reader;

public class TableReader
implements Reader {
    private final List<String> locationColumns;
    private final Cursor<Tuple> cursor;
    private final List<Column> columns;

    public TableReader(TableManager mgr, CopyLocationTable location) {
        String tableName = location.tableName();
        Table table = mgr.table("\"" + tableName + "\"");
        if (table == null) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, Static.RESOURCE.tableNotFound(tableName).str());
        }
        this.locationColumns = location.columns();
        this.columns = TableReader.schemaColumns(((TableImpl)table).schemaView().lastKnownSchema(), this.locationColumns, tableName);
        this.cursor = table.recordView().query(null, null);
    }

    @Override
    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    @Override
    public List<?> next() {
        return TableReader.asList((Tuple)this.cursor.next(), this.locationColumns);
    }

    @Override
    public void close() throws Exception {
        this.cursor.close();
    }

    @Override
    public List<Column> columns() {
        return this.columns;
    }

    private static List<Column> schemaColumns(SchemaDescriptor schema, List<String> locationColumns, String tableName) {
        ArrayList<Column> result = new ArrayList<Column>(locationColumns.size());
        for (String columnName : locationColumns) {
            Column col = schema.column(columnName);
            if (col == null) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, Static.RESOURCE.columnNotFoundInTable(columnName, tableName).str());
            }
            result.add(col);
        }
        return result;
    }

    private static List<Object> asList(Tuple tuple, List<String> columns) {
        ArrayList<Object> list = new ArrayList<Object>(columns.size());
        for (String column : columns) {
            list.add(tuple.value("\"" + column + "\""));
        }
        return list;
    }
}

