/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.aws.s3.S3OutputFile;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.parquet.Parquet;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopyLocationPath;
import org.apache.parquet.schema.MessageType;
import org.gridgain.internal.sql.copy.Writer;
import org.gridgain.internal.sql.copy.iceberg.IcebergUtils;
import org.gridgain.internal.sql.copy.s3.S3ClientFactory;
import org.gridgain.internal.sql.copy.s3.S3Utils;
import software.amazon.awssdk.services.s3.S3Client;

public class IcebergParquetWriter
implements Writer {
    private final Schema schema;
    private final DataWriter<Record> dataWriter;
    private final GenericRecord rec;

    public IcebergParquetWriter(CopyLocationPath into, Map<String, String> properties, List<Column> columns) throws IOException {
        if (CollectionUtils.isEmpty(columns)) {
            throw new IllegalArgumentException("Cannot read table table without schema descriptor");
        }
        this.schema = IcebergUtils.asIcebergSchema(columns);
        OutputFile outputFile = IcebergParquetWriter.getOutputFile(into.path(), IcebergUtils.combineProperties(into, properties));
        this.dataWriter = Parquet.writeData((OutputFile)outputFile).schema(this.schema).createWriterFunc(messageType -> GenericParquetWriter.create((Schema)this.schema, (MessageType)messageType)).overwrite().withSpec(PartitionSpec.unpartitioned()).build();
        this.rec = GenericRecord.create((Schema)this.schema);
    }

    @Override
    public void write(List<?> item) throws IOException {
        this.dataWriter.write((Object)IcebergUtils.asRecord(item, this.rec, this.schema));
    }

    @Override
    public void close() throws Exception {
        this.dataWriter.close();
    }

    private static OutputFile getOutputFile(String path, Map<String, String> properties) {
        if (S3Utils.isS3Scheme(path)) {
            return S3OutputFile.fromLocation((String)path, (S3Client)S3ClientFactory.createS3Client(properties), (S3FileIOProperties)new S3FileIOProperties(), (MetricsContext)MetricsContext.nullMetrics());
        }
        return Files.localOutput((File)Paths.get(path, new String[0]).toFile());
    }
}

