/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.structure;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.RenameTableCommand;
import org.apache.ignite3.internal.catalog.commands.RenameTableCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.gridgain.internal.snapshots.catalog.CommandState;
import org.gridgain.internal.snapshots.meta.StructureView;
import org.gridgain.internal.snapshots.structure.MapStructureHandler;
import org.gridgain.internal.snapshots.structure.SequenceStructureHandler;
import org.gridgain.internal.snapshots.structure.Structure;
import org.jetbrains.annotations.Nullable;

public interface StructureHandler {
    public Set<Structure> getStructures(Catalog var1);

    public Set<Structure> dependenciesForTables(Catalog var1, Collection<CatalogTableDescriptor> var2);

    @Nullable
    public Structure getStructure(Catalog var1, CatalogSchemaDescriptor var2, String var3);

    public boolean tryRestoreStructure(UpdateContext var1, CommandState var2, StructureView var3, int var4, int var5, AtomicInteger var6);

    public boolean tryDropStructure(UpdateContext var1, CommandState var2, StructureView var3);

    public Set<StructureView> createStructureDescriptors(Catalog var1, Set<Integer> var2);

    public static void renameSystemTable(CommandState commandState, StructureView view, String newName) {
        if (view.tableName().equals(newName)) {
            return;
        }
        commandState.applyCommand(((RenameTableCommandBuilder)((RenameTableCommandBuilder)RenameTableCommand.builder().schemaName("SYSTEM")).tableName(view.tableName())).newTableName(newName).validateSystemSchemas(false).build());
    }

    public static Set<StructureHandler> getStructureHandlers() {
        return StructureHandlersHolder.STRUCTURE_HANDLERS;
    }

    public static class StructureHandlersHolder {
        static final Set<StructureHandler> STRUCTURE_HANDLERS = Set.of(new MapStructureHandler(), new SequenceStructureHandler());
    }
}

