/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.filesystem;

import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.configuration.notifications.ConfigurationListener;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.encryption.DataEncryptionKeyNotFoundException;
import org.gridgain.internal.encryption.DataKeyGenerator;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.gridgain.internal.encryption.storage.DataEncryptionKeyManager;
import org.gridgain.internal.snapshots.SnapshotMetaNotFoundException;
import org.gridgain.internal.snapshots.SnapshotMetaSerializer;
import org.gridgain.internal.snapshots.SnapshotUriNotFoundException;
import org.gridgain.internal.snapshots.buffer.ByteBufferPoolProvider;
import org.gridgain.internal.snapshots.buffer.SnapshotEncryptor;
import org.gridgain.internal.snapshots.configuration.ClusterSnapshotConfiguration;
import org.gridgain.internal.snapshots.configuration.SnapshotUriView;
import org.gridgain.internal.snapshots.filesystem.EncryptedSnapshotFileSystem;
import org.gridgain.internal.snapshots.filesystem.LocalSnapshotFileSystem;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystem;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystemManager;
import org.gridgain.internal.snapshots.filesystem.SnapshotUri;
import org.gridgain.internal.snapshots.meta.SnapshotEncryptionMeta;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.signature.SnapshotSignature;
import org.gridgain.internal.snapshots.signature.SnapshotSignatureSerializer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SnapshotFileSystemManagerImpl
implements SnapshotFileSystemManager {
    public static final String SNAPSHOT_FOLDER_PREFIX = "snapshot-";
    private static final String FILE_SCHEMA = "file";
    public static final SnapshotUri DEFAULT_SNAPSHOT_URI = new SnapshotUri(URI.create("snapshots"), SnapshotUri.PathType.LOCAL);
    private final Path nodeWorkDir;
    private final ClusterSnapshotConfiguration clusterSnapshotConfiguration;
    private final ConfigurationListener<NamedListView<SnapshotUriView>> updatePathsListener;
    private final String nodeName;
    private volatile SnapshotUri defaultSnapshotUri;
    private final Map<String, SnapshotUri> pathByName = new ConcurrentHashMap<String, SnapshotUri>();
    private final SnapshotMetaSerializer snapshotMetaSerializer;
    private final SnapshotSignatureSerializer snapshotSignatureSerializer;
    private final Object snapshotPathsMutex = new Object();
    private final DataEncryptionKeyManager dataEncryptionKeyManager;
    private final ByteBufferPoolProvider bufferPoolProvider;

    public SnapshotFileSystemManagerImpl(ClusterSnapshotConfiguration clusterSnapshotConfiguration, Path nodeWorkDir, String nodeName, EncryptionManager encryptionManager, DataEncryptionKeyManager dataEncryptionKeyManager, ByteBufferPoolProvider bufferPoolProvider) {
        this.clusterSnapshotConfiguration = clusterSnapshotConfiguration;
        this.nodeName = nodeName;
        this.nodeWorkDir = nodeWorkDir;
        this.snapshotMetaSerializer = new SnapshotMetaSerializer();
        this.snapshotSignatureSerializer = new SnapshotSignatureSerializer(encryptionManager);
        this.dataEncryptionKeyManager = dataEncryptionKeyManager;
        this.bufferPoolProvider = bufferPoolProvider;
        this.updatePathsListener = event -> this.updatePaths((NamedListView)event.newValue());
    }

    @TestOnly
    public Path defaultSnapshotsPath() {
        return this.basePath(this.defaultSnapshotUri);
    }

    @Override
    public SnapshotFileSystem snapshotFileSystem(UUID snapshotId) {
        return this.snapshotFileSystem(snapshotId, this.snapshotUri(null));
    }

    @Override
    public SnapshotFileSystem snapshotFileSystem(UUID snapshotId, SnapshotUri snapshotUri) {
        URI uri = snapshotUri.uri();
        if (uri.getScheme() == null || FILE_SCHEMA.equals(uri.getScheme())) {
            Path basePath = this.basePath(snapshotUri);
            LocalSnapshotFileSystem localSnapshotFileSystem = new LocalSnapshotFileSystem(snapshotId, basePath.resolve(SNAPSHOT_FOLDER_PREFIX + snapshotId), this.bufferPoolProvider);
            SnapshotSignature signature = this.findSnapshotSignature(snapshotId, localSnapshotFileSystem);
            if (signature != null) {
                return new EncryptedSnapshotFileSystem(localSnapshotFileSystem, new SnapshotEncryptor(signature.key(), signature.cipherAlgorithm()), this.bufferPoolProvider);
            }
            return localSnapshotFileSystem;
        }
        throw new IllegalArgumentException("Unsupported URI scheme: " + uri.getScheme());
    }

    @Nullable
    private SnapshotSignature findSnapshotSignature(UUID snapshotId, SnapshotFileSystem snapshotFileSystem) {
        try {
            SnapshotMeta snapshotMeta = this.snapshotMetaSerializer.readSnapshotMeta(snapshotFileSystem);
            SnapshotEncryptionMeta encryption = snapshotMeta.encryption();
            return encryption != null ? this.snapshotSignatureSerializer.readSignature(encryption.signature(), encryption.providerName()) : null;
        }
        catch (SnapshotMetaNotFoundException e1) {
            try {
                DataEncryptionKey dataEncryptionKey = this.dataEncryptionKeyManager.activeKey(snapshotId.toString());
                return new SnapshotSignature(dataEncryptionKey, DataKeyGenerator.defaultCipherAlgorithm());
            }
            catch (DataEncryptionKeyNotFoundException e) {
                return null;
            }
        }
    }

    private Path basePath(SnapshotUri snapshotUri) {
        URI uri = snapshotUri.uri();
        if (!uri.isAbsolute()) {
            return this.nodeWorkDir.resolve(uri.getPath());
        }
        Path basePath = Path.of(uri);
        return snapshotUri.isSingleCopy() ? basePath : basePath.resolve(this.nodeName);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext context) {
        this.clusterSnapshotConfiguration.paths().listen(this.updatePathsListener);
        return this.updatePaths((NamedListView)this.clusterSnapshotConfiguration.paths().value());
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext context) {
        this.clusterSnapshotConfiguration.paths().stopListen(this.updatePathsListener);
        return CompletableFutures.nullCompletedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnapshotUri snapshotUri(@Nullable String name) {
        Object object = this.snapshotPathsMutex;
        synchronized (object) {
            if (name == null) {
                return this.defaultSnapshotUri;
            }
            SnapshotUri snapshotUri = this.pathByName.get(name);
            if (snapshotUri == null) {
                throw new SnapshotUriNotFoundException(name);
            }
            return snapshotUri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> updatePaths(@Nullable NamedListView<SnapshotUriView> paths) {
        Object object = this.snapshotPathsMutex;
        synchronized (object) {
            this.pathByName.clear();
            this.defaultSnapshotUri = null;
            if (paths != null) {
                paths.forEach(uriView -> {
                    SnapshotUri snapshotUri = new SnapshotUri(URI.create(uriView.uri()), SnapshotUri.PathType.valueOf(uriView.type()));
                    if (uriView.isDefault()) {
                        this.defaultSnapshotUri = snapshotUri;
                    }
                    this.pathByName.put(uriView.name(), snapshotUri);
                });
            }
            if (this.defaultSnapshotUri == null) {
                this.defaultSnapshotUri = DEFAULT_SNAPSHOT_URI;
            }
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

