/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.filesystem;

import java.nio.file.Path;
import java.util.UUID;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.gridgain.internal.snapshots.buffer.ByteBufferPoolProvider;
import org.gridgain.internal.snapshots.filesystem.LocalSnapshotMetaPath;
import org.gridgain.internal.snapshots.filesystem.LocalSnapshotPath;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystem;
import org.gridgain.internal.snapshots.filesystem.SnapshotMetaPath;
import org.gridgain.internal.snapshots.filesystem.SnapshotPath;

public class LocalSnapshotFileSystem
implements SnapshotFileSystem {
    private static final String META_FILE_NAME = "meta.json";
    private final UUID snapshotId;
    private final Path snapshotPath;
    private final ByteBufferPoolProvider bufferPoolProvider;

    public LocalSnapshotFileSystem(UUID snapshotId, Path snapshotPath, ByteBufferPoolProvider bufferPoolProvider) {
        this.snapshotId = snapshotId;
        this.snapshotPath = snapshotPath;
        this.bufferPoolProvider = bufferPoolProvider;
    }

    @Override
    public UUID snapshotId() {
        return this.snapshotId;
    }

    @Override
    public SnapshotMetaPath snapshotMeta() {
        return new LocalSnapshotMetaPath(this.snapshotPath.resolve(META_FILE_NAME));
    }

    @Override
    public SnapshotPath partitionFile(int tableId, int partitionId) {
        Path partitionFilePath = this.snapshotPath.resolve(String.valueOf(tableId)).resolve(String.valueOf(partitionId));
        return new LocalSnapshotPath(partitionFilePath, this.bufferPoolProvider);
    }

    @Override
    public void delete() {
        IgniteUtils.deleteIfExists(this.snapshotPath);
    }
}

