/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.metastorage.dsl.Operations;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;
import org.gridgain.internal.snapshots.coordinator.LocalSnapshotStateListener;
import org.gridgain.internal.snapshots.coordinator.SnapshotCoordinatorState;
import org.gridgain.internal.snapshots.coordinator.SnapshotOperations;

class CreateSnapshotLocalStateWatch
extends LocalSnapshotStateListener {
    private final CreateSnapshotGlobalState snapshotState;
    private final SnapshotOperations snapshotOperations;

    CreateSnapshotLocalStateWatch(SnapshotManagerContext context, SnapshotCoordinatorState snapshotCoordinatorState, CreateSnapshotGlobalState initialState) {
        super(context, snapshotCoordinatorState, initialState.operationId(), initialState.nodeNames());
        this.snapshotState = initialState;
        this.snapshotOperations = new SnapshotOperations(context);
    }

    @Override
    protected String nodeNameFromKey(byte[] key) {
        return MetaStorageKeys.nodeNameFromCreateLocalStateKey(key);
    }

    @Override
    protected CompletableFuture<List<Operation>> onSnapshotCompleteImpl(UUID operationId, String nodeName) {
        return this.completeSnapshotOperations(SnapshotStatus.COMPLETED, "");
    }

    @Override
    protected CompletableFuture<List<Operation>> onSnapshotFailedImpl(UUID operationId, String nodeName, String message) {
        return this.snapshotOperations.removeFromParentSnapshotDependencies(this.snapshotState.parentSnapshotId(), this.snapshotState.snapshotId()).thenCompose(ignored -> this.completeSnapshotOperations(SnapshotStatus.FAILED, message));
    }

    private CompletableFuture<List<Operation>> completeSnapshotOperations(SnapshotStatus status, String description) {
        CreateSnapshotGlobalState newGlobalState = new CreateSnapshotGlobalState(this.snapshotState.operationId(), status, this.snapshotState.nodeNames(), this.snapshotState.startTime(), this.snapshotState.tableIds(), this.snapshotState.tableNames(), this.snapshotState.structureNames(), this.snapshotState.structureIds(), this.snapshotState.fromTimestamp(), this.snapshotState.timestamp(), description, this.snapshotState.parentSnapshotId(), this.snapshotState.dependentSnapshotIds(), this.snapshotState.snapshotUri(), this.snapshotState.encryptionProviderName());
        ArrayList<Operation> operations = new ArrayList<Operation>();
        byte[] bytes = CreateSnapshotGlobalStateSerializer.serialize(newGlobalState);
        operations.add(Operations.put(MetaStorageKeys.createSnapshotGlobalStateKey(this.snapshotState.snapshotId()), bytes));
        for (String nodeName : this.snapshotState.nodeNames()) {
            operations.add(Operations.remove(MetaStorageKeys.createSnapshotLocalStateKey(this.snapshotState.snapshotId(), nodeName)));
        }
        return this.context.metaStorageManager().removeByPrefix(MetaStorageKeys.snapshotPartitionPrefix(this.snapshotState.snapshotId())).thenApply(v -> operations);
    }
}

