/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.messages;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.gridgain.internal.snapshots.communication.messages.RestoreSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.RestoreSnapshotMessageImpl;
import org.gridgain.internal.snapshots.communication.messages.SnapshotMessagesTypeInfos;

class RestoreSnapshotMessageSerializer
implements MessageSerializer<RestoreSnapshotMessage> {
    public static final RestoreSnapshotMessageSerializer INSTANCE = new RestoreSnapshotMessageSerializer();

    private RestoreSnapshotMessageSerializer() {
    }

    @Override
    public boolean writeMessage(RestoreSnapshotMessage msg, MessageWriter writer) throws MessageMappingException {
        RestoreSnapshotMessageImpl message = (RestoreSnapshotMessageImpl)msg;
        writer.setMessageTypeInfo(SnapshotMessagesTypeInfos.restoreSnapshotMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)6)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("encryptionProviderName", message.encryptionProviderName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("source", message.source());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeSet("tableNames", message.tableNames(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeUuid("targetSnapshotId", message.targetSnapshotId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeBoolean("force", message.force());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeSet("structureNames", message.structureNames(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

