/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.messages;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.gridgain.internal.snapshots.communication.messages.ErrorResponseMessage;
import org.gridgain.internal.snapshots.communication.messages.ErrorResponseMessageBuilder;
import org.gridgain.internal.snapshots.communication.messages.SnapshotMessagesFactory;
import org.gridgain.internal.snapshots.communication.messages.SnapshotMessagesTypeInfos;

class ErrorResponseMessageDeserializer
implements MessageDeserializer<ErrorResponseMessage> {
    private final ErrorResponseMessageBuilder msg;

    ErrorResponseMessageDeserializer(SnapshotMessagesFactory messageFactory) {
        this.msg = messageFactory.errorResponseMessage();
    }

    @Override
    public Class<ErrorResponseMessage> klass() {
        return ErrorResponseMessage.class;
    }

    @Override
    public ErrorResponseMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(SnapshotMessagesTypeInfos.errorResponseMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("errorByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.errorByteArray(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ErrorResponseMessage.class);
    }
}

