/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.catalog;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.gridgain.internal.snapshots.catalog.CommandState;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.meta.StructureView;
import org.gridgain.internal.snapshots.structure.StructureHandler;

public class CreateStructuresCommand
implements CatalogCommand {
    private final SnapshotMeta snapshotMeta;

    public CreateStructuresCommand(SnapshotMeta snapshotMeta) {
        this.snapshotMeta = snapshotMeta;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Collection<StructureView> views = this.snapshotMeta.structureDescriptors();
        if (views == null || views.isEmpty()) {
            return List.of();
        }
        Catalog catalog = updateContext.catalog();
        CommandState commandState = new CommandState(catalog);
        AtomicInteger nextGeneratedStructureId = new AtomicInteger(commandState.catalog().objectIdGenState() + 1);
        for (StructureView view : views) {
            int tableId = catalog.table("SYSTEM", view.tableName()).id();
            int schemaId = catalog.schema(view.schemaName()).id();
            for (StructureHandler handler : StructureHandler.getStructureHandlers()) {
                if (handler.tryRestoreStructure(updateContext, commandState, view, schemaId, tableId, nextGeneratedStructureId)) break;
            }
        }
        commandState.applyCommand(new ObjectIdGenUpdateEntry(views.size()));
        return commandState.updateEntries();
    }
}

