/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.buffer;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.gridgain.internal.lang.Disposable;
import org.gridgain.internal.snapshots.buffer.BufferAlreadyDisposedException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

public class DisposableByteBuffer
implements Disposable {
    @Nullable
    private ByteBuffer buffer;
    private Disposable disposable;

    public DisposableByteBuffer(ByteBuffer buffer, Disposable disposable) {
        this.buffer = Objects.requireNonNull(buffer);
        this.disposable = disposable;
    }

    public ByteBuffer buffer() {
        if (this.buffer == null) {
            throw new BufferAlreadyDisposedException(GridgainErrorGroups.Snapshots.SNAPSHOT_ERR);
        }
        return this.buffer;
    }

    @Override
    public void dispose() {
        this.buffer = null;
        this.disposable = Disposable.dispose(this.disposable);
    }
}

