/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.buffer;

import java.nio.ByteOrder;
import java.util.concurrent.CompletableFuture;
import org.gridgain.internal.snapshots.buffer.DisposableByteBuffer;

public class BufferAllocationRequest {
    private final ByteOrder order;
    private final CompletableFuture<DisposableByteBuffer> bufferFuture;

    public BufferAllocationRequest(ByteOrder order, CompletableFuture<DisposableByteBuffer> bufferFuture) {
        this.bufferFuture = bufferFuture;
        this.order = order;
    }

    public void complete(DisposableByteBuffer buffer) {
        buffer.buffer().order(this.order);
        this.bufferFuture.complete(buffer);
    }

    public void completeExceptionally(Throwable ex) {
        this.bufferFuture.completeExceptionally(ex);
    }
}

