/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.tombstones.Tombstone;
import org.apache.ignite3.internal.util.Cursor;
import org.gridgain.internal.snapshots.TableTombstoneProvider;
import org.gridgain.internal.snapshots.TableTombstoneResolver;
import org.jetbrains.annotations.Nullable;

public class TombstoneResolverFactory {
    private final TableTombstoneProvider tombstoneProvider;

    public TombstoneResolverFactory(TableTombstoneProvider tombstoneProvider) {
        this.tombstoneProvider = tombstoneProvider;
    }

    public TableTombstoneResolver create(final int partitionId, final HybridTimestamp fromTimestamp, final HybridTimestamp toTimestamp) {
        return new TableTombstoneResolver(){
            private final Cursor<Tombstone> tombstoneCursor;
            @Nullable
            private Tombstone nextTombstone;
            {
                this.tombstoneCursor = TombstoneResolverFactory.this.tombstoneProvider.cursor(partitionId, fromTimestamp, toTimestamp);
                this.nextTombstone = this.nextTombstone();
            }

            @Override
            public void close() {
                this.tombstoneCursor.close();
            }

            @Override
            public Iterable<RowId> resolveUntil(RowId rowId) {
                return () -> this.iteratorImpl(rowId);
            }

            @Nullable
            private Tombstone nextTombstone() {
                return this.tombstoneCursor.hasNext() ? (Tombstone)this.tombstoneCursor.next() : null;
            }

            private Iterator<RowId> iteratorImpl(final RowId rowId) {
                return new Iterator<RowId>(){

                    @Override
                    public boolean hasNext() {
                        return nextTombstone != null && nextTombstone.rowId().compareTo(rowId) < 0;
                    }

                    @Override
                    public RowId next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        RowId tombstoneId = nextTombstone.rowId();
                        nextTombstone = this.nextTombstone();
                        if (!this.hasNext()) {
                            this.skipUnrelated();
                        }
                        return tombstoneId;
                    }

                    private void skipUnrelated() {
                        while (nextTombstone != null && nextTombstone.rowId().equals(rowId)) {
                            nextTombstone = this.nextTombstone();
                        }
                    }
                };
            }
        };
    }
}

