/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.lang.RunnableX;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.gridgain.internal.snapshots.SnapshotCancelledException;
import org.gridgain.internal.snapshots.communication.metastorage.GlobalSnapshotState;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystem;

public class SnapshotContext<SnapshotStateT extends GlobalSnapshotState> {
    private final SnapshotStateT snapshotState;
    private final SnapshotFileSystem snapshotFileSystem;
    private final IgniteSpinBusyLock busyLock;
    private final long causalityToken;
    private final CompletableFuture<Void> completionFuture = new CompletableFuture();
    private final AtomicReference<CancellationState> cancellationState = new AtomicReference();

    SnapshotContext(SnapshotStateT snapshotState, SnapshotFileSystem snapshotFileSystem, IgniteSpinBusyLock busyLock, long causalityToken) {
        this.snapshotState = snapshotState;
        this.snapshotFileSystem = snapshotFileSystem;
        this.busyLock = busyLock;
        this.causalityToken = causalityToken;
    }

    UUID operationId() {
        return ((GlobalSnapshotState)this.snapshotState()).operationId();
    }

    SnapshotStateT snapshotState() {
        return this.snapshotState;
    }

    SnapshotFileSystem snapshotFileSystem() {
        return this.snapshotFileSystem;
    }

    long causalityToken() {
        return this.causalityToken;
    }

    void cancel() {
        this.cancellationState.compareAndSet(null, CancellationState.CANCELED);
    }

    void cancelByCoordinator() {
        this.cancellationState.compareAndSet(null, CancellationState.CANCELED_REMOTELY);
    }

    boolean isCancelledByCoordinator() {
        return this.cancellationState.get() == CancellationState.CANCELED_REMOTELY;
    }

    void complete() {
        this.completionFuture.complete(null);
    }

    CompletableFuture<Void> completionFuture() {
        return this.completionFuture;
    }

    boolean isCancelled() {
        return this.cancellationState.get() != null;
    }

    <T> T inBusyLock(Callable<T> action) {
        if (this.isCancelled()) {
            throw new SnapshotCancelledException();
        }
        if (!this.busyLock.enterBusy()) {
            throw new CompletionException(new NodeStoppingException());
        }
        try {
            T t = action.call();
            return t;
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    void inBusyLock(RunnableX action) {
        if (this.isCancelled()) {
            throw new SnapshotCancelledException();
        }
        if (!this.busyLock.enterBusy()) {
            throw new CompletionException(new NodeStoppingException());
        }
        try {
            action.run();
        }
        catch (Throwable e) {
            throw new CompletionException(e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> CompletableFuture<T> inBusyLockAsync(Callable<CompletableFuture<T>> action) {
        if (this.isCancelled()) {
            return CompletableFuture.failedFuture(new SnapshotCancelledException());
        }
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletableFuture<T> completableFuture = action.call();
            return completableFuture;
        }
        catch (Throwable e) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(e);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private static enum CancellationState {
        CANCELED,
        CANCELED_REMOTELY;

    }
}

