/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.ldap.client;

import java.util.Set;
import javax.naming.NamingException;
import org.gridgain.internal.security.ldap.LdapFilter;
import org.gridgain.internal.security.ldap.LdapSearchParams;
import org.gridgain.internal.security.ldap.LdapUserContext;
import org.gridgain.internal.security.ldap.ScopeType;
import org.gridgain.internal.security.ldap.client.LdapClient;
import org.gridgain.internal.security.ldap.client.LdapConnection;
import org.gridgain.internal.security.ldap.configuration.LdapAuthenticationProviderView;
import org.gridgain.internal.security.ldap.configuration.LdapGroupSearchView;
import org.gridgain.internal.security.ldap.configuration.LdapUserSearchView;
import org.gridgain.internal.security.ldap.exception.LdapAuthenticationException;
import org.gridgain.lang.GridgainErrorGroups;

public class LdapClientImpl
implements LdapClient {
    private final LdapAuthenticationProviderView ldapAuthenticationProviderView;

    public LdapClientImpl(LdapAuthenticationProviderView ldapAuthenticationProviderView) {
        this.ldapAuthenticationProviderView = ldapAuthenticationProviderView;
    }

    @Override
    public LdapUserContext authenticate(String username, String password) throws LdapAuthenticationException {
        LdapUserContext ldapUserContext;
        LdapUserSearchView userSearchCfg = this.ldapAuthenticationProviderView.userSearch();
        LdapSearchParams userSearch = new LdapSearchParams(userSearchCfg.dn(), new LdapFilter(userSearchCfg.filter()), ScopeType.valueOf(userSearchCfg.scope()), userSearchCfg.groupAttribute());
        LdapGroupSearchView groupSearchCfg = this.ldapAuthenticationProviderView.groupSearch();
        LdapSearchParams groupSearch = new LdapSearchParams(groupSearchCfg.dn(), new LdapFilter(groupSearchCfg.filter()), ScopeType.valueOf(groupSearchCfg.scope()), groupSearchCfg.userAttribute());
        LdapConnection connection = new LdapConnection(this.ldapAuthenticationProviderView.url(), userSearch, groupSearch, username, password);
        try {
            Set<String> groups = connection.groups();
            ldapUserContext = new LdapUserContext(username, groups);
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NamingException e) {
                throw new LdapAuthenticationException(GridgainErrorGroups.Ldap.LDAP_CLIENT_INIT_ERR, "Failed to init LDAP client", (Throwable)e);
            }
        }
        connection.close();
        return ldapUserContext;
    }
}

