/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.ldap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.gridgain.internal.security.ldap.ScopeType;

public class LdapCatalog {
    private static final Map<String, String> BASE_CONFIG = Map.of("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory", "java.naming.security.authentication", "simple");
    private final DirContext context;

    public LdapCatalog(String url, String user, String password) throws NamingException {
        Hashtable<String, String> environment = new Hashtable<String, String>(BASE_CONFIG);
        environment.put("java.naming.provider.url", url);
        environment.put("java.naming.security.principal", user);
        environment.put("java.naming.security.credentials", password);
        this.context = new InitialDirContext(environment);
    }

    public List<Map<String, List<String>>> search(String dn, String filter, ScopeType scope, String ... attributes) throws NamingException {
        SearchControls searchControls = new SearchControls();
        if (attributes.length > 0) {
            searchControls.setReturningAttributes(attributes);
        }
        searchControls.setSearchScope(LdapCatalog.mapToSearchControls(scope));
        NamingEnumeration<SearchResult> search = this.context.search(dn, filter, searchControls);
        return LdapCatalog.convertResult(search);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, List<String>>> convertResult(NamingEnumeration<SearchResult> searchResult) throws NamingException {
        ArrayList<Map<String, List<String>>> result = new ArrayList<Map<String, List<String>>>();
        while (searchResult.hasMore()) {
            SearchResult next = searchResult.next();
            Attributes attributes = next.getAttributes();
            NamingEnumeration<? extends Attribute> all = null;
            try {
                all = attributes.getAll();
                HashMap map = new HashMap();
                while (all.hasMore()) {
                    Attribute attr = all.next();
                    map.put(attr.getID(), Collections.list(attr.getAll()).stream().map(Object::toString).collect(Collectors.toList()));
                }
                result.add(map);
            }
            finally {
                if (all == null) continue;
                all.close();
            }
        }
        return result;
    }

    private static int mapToSearchControls(ScopeType scopeType) {
        switch (scopeType) {
            case ONE_LEVEL: {
                return 1;
            }
            case SUB_TREE: {
                return 2;
            }
            case BASE: {
                return 0;
            }
        }
        return -1;
    }

    public void close() throws NamingException {
        this.context.close();
    }
}

