/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key.store.serde;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.Instant;
import org.gridgain.internal.security.key.exception.KeySerDeException;
import org.gridgain.internal.security.key.store.KeyMetadataRecord;

public final class MetadataKeyRecordSerDe {
    private MetadataKeyRecordSerDe() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(KeyMetadataRecord metadata) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                dos.writeInt(metadata.id());
                dos.writeLong(metadata.issuedAt().toEpochMilli());
                dos.writeLong(metadata.expirationTime().toEpochMilli());
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new KeySerDeException("Failed to serialize key record", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static KeyMetadataRecord deserialize(byte[] bytes) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            KeyMetadataRecord keyMetadataRecord;
            try (DataInputStream dis = new DataInputStream(bais);){
                int id = dis.readInt();
                Instant issuedAt = Instant.ofEpochMilli(dis.readLong());
                Instant expirationTime = Instant.ofEpochMilli(dis.readLong());
                keyMetadataRecord = new KeyMetadataRecord(id, issuedAt, expirationTime);
            }
            return keyMetadataRecord;
        }
        catch (IOException e) {
            throw new KeySerDeException("Failed to deserialize key record", (Throwable)e);
        }
    }
}

