/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key;

import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.gridgain.internal.security.key.KeyDecoder;
import org.gridgain.internal.security.key.exception.KeyDecodingException;

class RsaKeyDecoder
implements KeyDecoder<RSAPrivateKey, RSAPublicKey> {
    RsaKeyDecoder() {
    }

    @Override
    public RSAPrivateKey decodePrivateKey(byte[] keyBytes) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new KeyDecodingException("Failed to decode private key", (Throwable)e);
        }
    }

    @Override
    public RSAPublicKey decodePublicKey(byte[] keyBytes) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new KeyDecodingException("Failed to decode public key", (Throwable)e);
        }
    }
}

