/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key;

import java.security.PublicKey;
import java.util.Objects;
import org.gridgain.internal.security.key.IgnitePublicKey;
import org.jetbrains.annotations.Nullable;

class PublicKeyChain<K extends PublicKey> {
    private final IgnitePublicKey<K> currentKey;
    @Nullable
    private final IgnitePublicKey<K> prevKey;

    PublicKeyChain(IgnitePublicKey<K> currentKey, @Nullable IgnitePublicKey<K> prevKey) {
        this.currentKey = currentKey;
        this.prevKey = prevKey;
    }

    PublicKeyChain<K> merge(IgnitePublicKey<K> newKey) {
        if (newKey.equals(this.currentKey)) {
            return this;
        }
        if (newKey.metadata().issuedAt().isAfter(this.currentKey.metadata().issuedAt())) {
            return new PublicKeyChain<K>(newKey, this.currentKey);
        }
        throw new IllegalStateException("The new key is older than the current one.");
    }

    IgnitePublicKey<K> currentKey() {
        return this.currentKey;
    }

    @Nullable
    IgnitePublicKey<K> prevKey() {
        return this.prevKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyChain that = (PublicKeyChain)o;
        return Objects.equals(this.currentKey, that.currentKey) && Objects.equals(this.prevKey, that.prevKey);
    }

    public int hashCode() {
        return Objects.hash(this.currentKey, this.prevKey);
    }
}

