/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.context;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gridgain.internal.security.context.BasicAuthentication;
import org.gridgain.internal.security.context.SecuredCallable;
import org.gridgain.internal.security.context.SecuredConsumer;
import org.gridgain.internal.security.context.SecuredFunction;
import org.gridgain.internal.security.context.SecuredRunnable;
import org.gridgain.internal.security.context.SecuredSupplier;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.gridgain.internal.security.context.SecurityContextImpl;
import org.jetbrains.annotations.Nullable;

public final class GridGainSecurity {
    public static <T> Callable<T> callWith(@Nullable SecurityContext ctx, Callable<T> callable) {
        return new SecuredCallable<T>(callable, ctx);
    }

    public static <T> Supplier<T> with(@Nullable SecurityContext ctx, Supplier<T> supplier) {
        return new SecuredSupplier<T>(supplier, ctx);
    }

    public static <T> Consumer<T> with(@Nullable SecurityContext ctx, Consumer<T> consumer) {
        return new SecuredConsumer<T>(consumer, ctx);
    }

    public static Runnable with(@Nullable SecurityContext ctx, Runnable runnable) {
        return new SecuredRunnable(runnable, ctx);
    }

    public static <T, R> Function<T, R> with(@Nullable SecurityContext ctx, Function<T, R> function) {
        return new SecuredFunction<T, R>(function, ctx);
    }

    public static <T> Callable<T> callWithContext(Callable<T> callable) {
        return new SecuredCallable<T>(callable, SecurityContextHolder.getOrThrow());
    }

    public static <T> Supplier<T> withContext(Supplier<T> supplier) {
        return new SecuredSupplier<T>(supplier, SecurityContextHolder.getOrThrow());
    }

    public static Runnable withContext(Runnable runnable) {
        return new SecuredRunnable(runnable, SecurityContextHolder.getOrThrow());
    }

    public static <T, R> Function<T, R> withContext(Function<T, R> function) {
        return new SecuredFunction<T, R>(function, SecurityContextHolder.getOrThrow());
    }

    public static SecurityContext context(String username, Set<String> roles) {
        return new SecurityContextImpl(new BasicAuthentication(username, roles));
    }

    public static <T> T bypass(Supplier<T> supplier) {
        return GridGainSecurity.getWith(GridGainSecurity.systemContext(), supplier);
    }

    public static <T> T getWith(@Nullable SecurityContext ctx, Supplier<T> supplier) {
        return GridGainSecurity.with(ctx, supplier).get();
    }

    public static SecurityContext systemContext() {
        return new SecurityContextImpl(new BasicAuthentication("gridgain-system-user", Set.of("gridgain-system-bypass")));
    }
}

