/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.recovery.pitr;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.recovery.pitr.PitrApi;
import org.apache.ignite3.internal.rest.api.recovery.pitr.TableRecoveryStatus;
import org.apache.ignite3.internal.rest.api.recovery.pitr.TablesRecoveryRequest;
import org.apache.ignite3.internal.rest.api.recovery.pitr.TablesRecoveryResponse;
import org.apache.ignite3.internal.rest.api.recovery.pitr.TablesRecoveryStateResponse;
import org.gridgain.internal.pitr.PitrFacade;
import org.gridgain.internal.rest.SecurityContextAware;

@Controller(value="/management/v1/recovery/tables")
public class PitrController
implements PitrApi,
ResourceHolder,
SecurityContextAware {
    private PitrFacade pitr;
    private final SecurityService securityService;

    public PitrController(PitrFacade pitr, SecurityService securityService) {
        this.pitr = pitr;
        this.securityService = securityService;
    }

    @Override
    public CompletableFuture<TablesRecoveryResponse> recoverTables(TablesRecoveryRequest request) {
        return this.secured(() -> this.pitr.recoverTables(request.timestamp(), request.tables()).thenApply(TablesRecoveryResponse::new));
    }

    @Override
    public CompletableFuture<TablesRecoveryStateResponse> getTablesRecoveryState(UUID operationId) {
        return this.secured(() -> this.pitr.getRecoveryState(operationId).thenApply(state -> new TablesRecoveryStateResponse(state.progress(), TableRecoveryStatus.fromId(state.status().id()))));
    }

    @Override
    public void cleanResources() {
        this.pitr = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

