/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.rbac.assignments;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.rbac.assignmens.RoleAssignment;
import org.apache.ignite3.internal.rest.api.rbac.assignmens.RoleAssignmentsApi;
import org.apache.ignite3.internal.rest.api.rbac.privileges.Privilege;
import org.apache.ignite3.internal.rest.api.rbac.role.RoleDto;
import org.apache.ignite3.internal.rest.api.rbac.role.RoleViewDto;
import org.apache.ignite3.internal.rest.api.rbac.user.UserDto;
import org.apache.ignite3.internal.rest.api.rbac.user.UserRoles;
import org.gridgain.internal.rbac.assignments.RoleAssignmentManagement;
import org.gridgain.internal.rbac.roles.Role;
import org.gridgain.internal.rbac.roles.RoleView;
import org.gridgain.internal.rbac.users.User;
import org.gridgain.internal.rest.SecurityContextAware;

@Controller(value="/management/v1/rbac/ra")
public class RoleAssignmentsController
implements RoleAssignmentsApi,
ResourceHolder,
SecurityContextAware {
    private RoleAssignmentManagement roleAssignmentManagement;
    private final SecurityService securityService;

    public RoleAssignmentsController(RoleAssignmentManagement roleAssignmentManagement, SecurityService securityService) {
        this.roleAssignmentManagement = roleAssignmentManagement;
        this.securityService = securityService;
    }

    private static Collection<RoleDto> toRoleDto(Set<Role> roles) {
        return roles.stream().map(role -> new RoleDto(role.name())).collect(Collectors.toList());
    }

    private static Collection<UserDto> toUserDto(Set<User> users) {
        return users.stream().map(user -> new UserDto(user.username())).collect(Collectors.toList());
    }

    private static Collection<Privilege> toPrivilegeDtoCollection(Set<org.gridgain.internal.rbac.privileges.Privilege> privileges) {
        return privileges.stream().map(privilege -> new Privilege(privilege.action().name(), privilege.selector().toRawString())).collect(Collectors.toList());
    }

    private static Iterable<UserRoles> toUserRolesDto(Map<User, Set<Role>> userRoles) {
        return userRoles.entrySet().stream().map(entry -> new UserRoles(((User)entry.getKey()).username(), RoleAssignmentsController.toRoleDto((Set)entry.getValue()))).collect(Collectors.toList());
    }

    private static Iterable<RoleViewDto> toRoleViewsDto(Set<RoleView> roles) {
        return roles.stream().map(role -> new RoleViewDto(role.roleName(), RoleAssignmentsController.toUserDto(role.assignedUsers()), RoleAssignmentsController.toPrivilegeDtoCollection(role.privileges()))).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<Iterable<RoleDto>> roles(String username) {
        return this.secured(() -> this.roleAssignmentManagement.rolesByUserAsync(username).thenApply(RoleAssignmentsController::toRoleDto));
    }

    @Override
    public CompletableFuture<Iterable<UserDto>> users(String roleName) {
        return this.secured(() -> this.roleAssignmentManagement.usersByRoleAsync(roleName).thenApply(RoleAssignmentsController::toUserDto));
    }

    @Override
    public CompletableFuture<Iterable<UserRoles>> usersWithRoles() {
        return this.secured(() -> this.roleAssignmentManagement.usersViewsAsync().thenApply(RoleAssignmentsController::toUserRolesDto));
    }

    @Override
    public CompletableFuture<Iterable<RoleViewDto>> rolesViews() {
        return this.secured(() -> this.roleAssignmentManagement.rolesViewsAsync().thenApply(RoleAssignmentsController::toRoleViewsDto));
    }

    @Override
    public CompletableFuture<Void> assign(RoleAssignment roleAssignment) {
        return this.secured(() -> this.roleAssignmentManagement.assignAsync(roleAssignment.roleNames(), roleAssignment.usernames()));
    }

    @Override
    public CompletableFuture<Void> revoke(RoleAssignment roleAssignment) {
        return this.secured(() -> this.roleAssignmentManagement.revokeAsync(roleAssignment.roleNames(), roleAssignment.usernames()));
    }

    @Override
    public void cleanResources() {
        this.roleAssignmentManagement = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

