/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.recovery.progress;

import java.util.UUID;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.gridgain.internal.recovery.progress.RecoveryProgressHandler;

public class LogProgressHandler
implements RecoveryProgressHandler {
    private final UUID id;
    private final IgniteLogger logger;

    public LogProgressHandler(UUID id, IgniteLogger logger) {
        this.id = id;
        this.logger = logger;
    }

    @Override
    public void handlePartitionRecoveryFinished(int tableId, int partition, long rowsUpdated, long recoveryTime) {
        this.logger.info("Recovery operation {}: Partition {} of table {} has been successfully restored in {} ms, number of rows: {}.", this.id, partition, tableId, recoveryTime, rowsUpdated);
    }

    @Override
    public void handleTableRecoveryFinished(int tableId, long rowsUpdated, long recoveryTime) {
        this.logger.info("Recovery operation {}: Table {} has been successfully restored in {} ms, number of rows: {}.", this.id, tableId, recoveryTime, rowsUpdated);
    }

    @Override
    public void handleRecoveryFinished(long rowsUpdated, long recoveryTime) {
        this.logger.info("Recovery operation {} has successfully finished in {} ms, number of rows restored: {}", this.id, recoveryTime, rowsUpdated);
    }

    @Override
    public void handleRecoveryException(Throwable ex) {
        this.logger.error("Recovery operation has failed ", ex);
    }
}

