/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.recovery;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.table.TableImpl;
import org.apache.ignite3.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.gridgain.internal.recovery.PartitionRecovery;
import org.gridgain.internal.recovery.Recovery;
import org.gridgain.internal.recovery.RecoveryRequest;
import org.gridgain.internal.recovery.StorageProvider;
import org.gridgain.internal.recovery.TableInfo;
import org.gridgain.internal.recovery.TableProvider;
import org.gridgain.internal.recovery.statistic.RecoveryStatistic;
import org.gridgain.internal.recovery.statistic.accumulator.TimeStatisticCollector;

class TableRecovery
implements Recovery {
    private final TableProvider tableProvider;
    private final TableInfo tableInfo;
    private final RecoveryStatistic statisticManager;
    private final RecoveryRequest request;
    private final List<PartitionRecovery> recoveries;

    TableRecovery(TableProvider tableProvider, TableInfo tableInfo, RecoveryStatistic statisticManager, RecoveryRequest request) {
        this.tableProvider = tableProvider;
        this.tableInfo = tableInfo;
        this.statisticManager = statisticManager;
        this.request = request;
        StorageProvider storageProvider = this.storageProvider();
        this.recoveries = tableInfo.partitions().stream().mapToObj(partitionId -> new PartitionRecovery(storageProvider, tableInfo.dataProvider(), tableInfo.binaryRowUpgrader(), partitionId, request.timestampToRecovery(), request.threadPool(), request.recoveryBatchSize(), request.lastInChain(), statisticManager.rowsStatisticAccumulator(tableInfo.tableId(), partitionId))).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<Void> start() {
        int tableId = this.tableInfo.tableId();
        TimeStatisticCollector statisticAccumulator = this.statisticManager.timeStatisticCollector(tableId);
        statisticAccumulator.recoveryStarted();
        CompletableFuture[] recoveryFutures = new CompletableFuture[this.recoveries.size()];
        for (int i = 0; i < this.recoveries.size(); ++i) {
            PartitionRecovery partitionRecovery = this.recoveries.get(i);
            int partitionId = partitionRecovery.partitionId();
            CompletionStage recoveryFuture = partitionRecovery.start().whenComplete((v, e) -> {
                if (e != null) {
                    this.cancel();
                } else {
                    this.request.handler().handlePartitionRecoveryFinished(tableId, partitionId, this.statisticManager.recoveredRowsForPartition(tableId, partitionId), this.statisticManager.recoveryTimeForPartition(tableId, partitionId));
                }
            });
            recoveryFutures[i] = recoveryFuture;
        }
        return CompletableFuture.allOf(recoveryFutures).whenComplete((unused, throwable) -> {
            statisticAccumulator.recoveryFinished();
            if (throwable == null) {
                this.request.handler().handleTableRecoveryFinished(tableId, this.statisticManager.recoveredRowsForTable(tableId), this.statisticManager.recoveryTimeForTable(tableId));
            }
        });
    }

    @Override
    public void cancel() {
        this.recoveries.forEach(PartitionRecovery::cancel);
    }

    private StorageProvider storageProvider() {
        final TableImpl table = this.tableProvider.getTable(this.tableInfo.tableId());
        assert (table != null) : String.format("Table not found: id=%d", this.tableInfo.tableId());
        return new StorageProvider(){

            @Override
            public MvPartitionStorage partitionStorage(int partition) {
                MvPartitionStorage partitionStorage = table.internalTable().storage().getMvPartition(partition);
                assert (partitionStorage != null) : "Missing partition storage: " + partition;
                return partitionStorage;
            }

            @Override
            public Collection<TableSchemaAwareIndexStorage> indexStorages(int partition) {
                return table.indexStorageAdapters(partition).get().values();
            }
        };
    }
}

