/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.recovery;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.gridgain.internal.recovery.TableInfo;
import org.gridgain.internal.recovery.progress.RecoveryProgressHandler;

public class RecoveryRequest {
    private final UUID id;
    private final List<TableInfo> tables;
    private final HybridTimestamp timestamp;
    private final int recoveryBatchSize;
    private final ExecutorService threadPool;
    private final RecoveryProgressHandler handler;
    private final boolean lastInChain;

    private RecoveryRequest(UUID id, List<TableInfo> tables, HybridTimestamp timestamp, int recoveryBatchSize, ExecutorService threadPool, RecoveryProgressHandler handler, boolean lastInChain) {
        this.id = id;
        this.tables = tables;
        this.timestamp = timestamp;
        this.recoveryBatchSize = recoveryBatchSize;
        this.threadPool = threadPool;
        this.handler = handler;
        this.lastInChain = lastInChain;
    }

    public UUID id() {
        return this.id;
    }

    public List<TableInfo> tables() {
        return this.tables;
    }

    public HybridTimestamp timestampToRecovery() {
        return this.timestamp;
    }

    public int recoveryBatchSize() {
        return this.recoveryBatchSize;
    }

    public ExecutorService threadPool() {
        return this.threadPool;
    }

    public RecoveryProgressHandler handler() {
        return this.handler;
    }

    public boolean lastInChain() {
        return this.lastInChain;
    }

    public static RecoveryRequestBuilder builder() {
        return new RecoveryRequestBuilder();
    }

    public static class RecoveryRequestBuilder {
        private UUID id;
        private List<TableInfo> tables;
        private HybridTimestamp timestamp;
        private Integer recoveryBatchSize;
        private ExecutorService threadPool;
        private RecoveryProgressHandler handler = RecoveryProgressHandler.NOOP;
        private Boolean lastInChain;

        public RecoveryRequestBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public RecoveryRequestBuilder tables(List<TableInfo> tableInfos) {
            this.tables = tableInfos;
            return this;
        }

        public RecoveryRequestBuilder timestampToRecovery(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public RecoveryRequestBuilder recoveryBatchSize(int recoveryBatchSize) {
            this.recoveryBatchSize = recoveryBatchSize;
            return this;
        }

        public RecoveryRequestBuilder threadPool(ExecutorService threadPool) {
            this.threadPool = threadPool;
            return this;
        }

        public RecoveryRequestBuilder handler(RecoveryProgressHandler handler) {
            this.handler = handler;
            return this;
        }

        public RecoveryRequestBuilder lastInChain(boolean lastInChain) {
            this.lastInChain = lastInChain;
            return this;
        }

        public RecoveryRequest build() {
            Objects.requireNonNull(this.id);
            Objects.requireNonNull(this.tables);
            Objects.requireNonNull(this.recoveryBatchSize);
            Objects.requireNonNull(this.threadPool);
            Objects.requireNonNull(this.handler);
            Objects.requireNonNull(this.lastInChain);
            return new RecoveryRequest(this.id, this.tables, this.timestamp, this.recoveryBatchSize, this.threadPool, this.handler, this.lastInChain);
        }
    }
}

