/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.recovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowImpl;
import org.apache.ignite3.internal.schema.BinaryRowUpgrader;
import org.apache.ignite3.internal.storage.BinaryRowAndRowId;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.recovery.Recovery;
import org.gridgain.internal.recovery.StorageProvider;
import org.gridgain.internal.recovery.TableDataProvider;
import org.gridgain.internal.recovery.statistic.accumulator.RowsStatisticAccumulator;
import org.jetbrains.annotations.Nullable;

public class PartitionRecovery
implements Recovery {
    public static final int TEMP_TABLE_SCHEMA_VERSION = 1;
    private static final int UUID_SIZE = 16;
    private final RowsStatisticAccumulator rowsStatisticAccumulator;
    private final StorageProvider storageProvider;
    private final TableDataProvider dataProvider;
    private final HybridTimestamp timestamp;
    private final int partitionId;
    private final ExecutorService threadPool;
    private final int batchSize;
    @Nullable
    private final BinaryRowUpgrader rowUpgrader;
    private final boolean lastInChain;
    private volatile boolean stopped = false;

    public PartitionRecovery(StorageProvider storageProvider, TableDataProvider dataProvider, @Nullable BinaryRowUpgrader rowUpgrader, int partitionId, HybridTimestamp timestamp, ExecutorService threadPool, int batchSize, boolean lastInChain, RowsStatisticAccumulator rowsStatisticAccumulator) {
        this.storageProvider = storageProvider;
        this.dataProvider = dataProvider;
        this.rowUpgrader = rowUpgrader;
        this.partitionId = partitionId;
        this.timestamp = timestamp;
        this.threadPool = threadPool;
        this.batchSize = batchSize;
        this.lastInChain = lastInChain;
        this.rowsStatisticAccumulator = rowsStatisticAccumulator;
    }

    @Override
    public CompletableFuture<Void> start() {
        return this.recoverPartitionAsync();
    }

    @Override
    public void cancel() {
        this.stopped = true;
    }

    public int partitionId() {
        return this.partitionId;
    }

    private CompletableFuture<Void> recoverPartitionAsync() {
        this.rowsStatisticAccumulator.recoveryStarted();
        MvPartitionStorage partitionStorage = this.storageProvider.partitionStorage(this.partitionId);
        return ((CompletableFuture)this.recoverPartition(partitionStorage).thenCompose(v -> this.onPartitionRestored(partitionStorage))).whenComplete((v, e) -> this.rowsStatisticAccumulator.recoveryFinished());
    }

    private CompletableFuture<Void> recoverPartition(final MvPartitionStorage partitionStorage) {
        final Collection<TableSchemaAwareIndexStorage> indexStorages = this.storageProvider.indexStorages(this.partitionId);
        Flow.Publisher<BinaryRowAndRowId> publisher = this.dataProvider.partitionDataAsync(this.partitionId, this.threadPool);
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        publisher.subscribe(new Flow.Subscriber<BinaryRowAndRowId>(){
            private final List<BinaryRowAndRowId> rows = new ArrayList<BinaryRowAndRowId>();
            private int batchLength = 0;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(BinaryRowAndRowId row) {
                if (PartitionRecovery.this.stopped) {
                    return;
                }
                BinaryRow binaryRow = row.binaryRow();
                int tupleLength = 16 + (binaryRow == null ? 0 : binaryRow.tupleSliceLength());
                if (this.batchLength + tupleLength > PartitionRecovery.this.batchSize && !this.rows.isEmpty()) {
                    int savedRows = PartitionRecovery.this.saveRows(this.rows, partitionStorage, indexStorages);
                    PartitionRecovery.this.rowsStatisticAccumulator.addRows(savedRows);
                    this.rows.clear();
                    this.batchLength = 0;
                }
                this.batchLength += tupleLength;
                this.rows.add(row);
            }

            @Override
            public void onError(Throwable throwable) {
                result.completeExceptionally(throwable);
            }

            @Override
            public void onComplete() {
                if (!this.rows.isEmpty()) {
                    int savedRows = PartitionRecovery.this.saveRows(this.rows, partitionStorage, indexStorages);
                    PartitionRecovery.this.rowsStatisticAccumulator.addRows(savedRows);
                }
                result.complete(null);
            }
        });
        return result;
    }

    private int saveRows(List<BinaryRowAndRowId> rows, MvPartitionStorage partitionStorage, Collection<TableSchemaAwareIndexStorage> indexStorages) {
        return partitionStorage.runConsistently(locker -> {
            for (BinaryRowAndRowId row : rows) {
                RowId rowId = row.rowId();
                locker.lock(rowId);
                BinaryRow binaryRow = row.binaryRow();
                if (binaryRow != null && this.rowUpgrader != null) {
                    binaryRow = new BinaryRowImpl(1, this.rowUpgrader.upgradeByteBuffer(binaryRow));
                }
                partitionStorage.addWriteCommitted(rowId, binaryRow, this.timestamp);
                if (binaryRow == null) continue;
                for (TableSchemaAwareIndexStorage indexStorage : indexStorages) {
                    indexStorage.put(binaryRow, rowId);
                }
            }
            return rows.size();
        });
    }

    private CompletableFuture<Void> onPartitionRestored(MvPartitionStorage partitionStorage) {
        if (this.lastInChain) {
            return partitionStorage.flush();
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

