/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.privileges;

import org.gridgain.internal.rbac.privileges.ObjectType;

public enum Action {
    READ_CLUSTER_CONFIG(ObjectType.CLUSTER),
    WRITE_CLUSTER_CONFIG(ObjectType.CLUSTER),
    READ_NODE_CONFIG(ObjectType.CLUSTER),
    WRITE_NODE_CONFIG(ObjectType.CLUSTER),
    DEPLOY_UNIT(ObjectType.CLUSTER),
    UNDEPLOY_UNIT(ObjectType.CLUSTER),
    READ_UNIT(ObjectType.CLUSTER),
    EXEC_JOB(ObjectType.DEPLOYMENT_UNIT),
    GET_JOB_STATE(ObjectType.CLUSTER, true),
    KILL_JOB(ObjectType.CLUSTER, true),
    CHANGE_JOB_PRIORITY(ObjectType.CLUSTER, true),
    KILL_TRANSACTION(ObjectType.CLUSTER),
    GET_TRANSACTION_STATE(ObjectType.CLUSTER),
    KILL_QUERY(ObjectType.CLUSTER),
    GET_SQL_QUERY_STATE(ObjectType.CLUSTER),
    ENABLE_METRICS(ObjectType.CLUSTER),
    DISABLE_METRICS(ObjectType.CLUSTER),
    LIST_METRICS(ObjectType.CLUSTER),
    READ_METRICS(ObjectType.CLUSTER),
    EDIT_USER(ObjectType.CLUSTER, true),
    READ_USER(ObjectType.CLUSTER, true),
    CREATE_USER(ObjectType.CLUSTER),
    DROP_USER(ObjectType.CLUSTER),
    CREATE_ROLE(ObjectType.CLUSTER),
    READ_ROLE(ObjectType.CLUSTER),
    DROP_ROLE(ObjectType.CLUSTER),
    GRANT_ROLE(ObjectType.CLUSTER),
    REVOKE_ROLE(ObjectType.CLUSTER),
    GRANT_PRIVILEGE(ObjectType.CLUSTER),
    REVOKE_PRIVILEGE(ObjectType.CLUSTER),
    CREATE_DISTRIBUTION_ZONE(ObjectType.CLUSTER),
    ALTER_DISTRIBUTION_ZONE(ObjectType.CLUSTER),
    DROP_DISTRIBUTION_ZONE(ObjectType.CLUSTER),
    RESET_DISTRIBUTION_STATE(ObjectType.CLUSTER),
    RESTART_PARTITIONS(ObjectType.CLUSTER),
    RESET_PARTITIONS(ObjectType.CLUSTER),
    CREATE_SCHEMA(ObjectType.SCHEMA),
    DROP_SCHEMA(ObjectType.SCHEMA),
    READ_SCHEMA(ObjectType.SCHEMA),
    CREATE_TABLE(ObjectType.TABLE),
    SELECT_FROM_TABLE(ObjectType.TABLE),
    ALTER_TABLE(ObjectType.TABLE),
    DROP_TABLE(ObjectType.TABLE),
    INSERT_INTO_TABLE(ObjectType.TABLE),
    UPDATE_TABLE(ObjectType.TABLE),
    DELETE_FROM_TABLE(ObjectType.TABLE),
    CREATE_VIEW(ObjectType.VIEW),
    SELECT_FROM_VIEW(ObjectType.VIEW),
    ALTER_VIEW(ObjectType.VIEW),
    DROP_VIEW(ObjectType.VIEW),
    CREATE_INDEX(ObjectType.TABLE),
    DROP_INDEX(ObjectType.TABLE),
    USE_INDEX(ObjectType.TABLE),
    CREATE_SNAPSHOT(ObjectType.CLUSTER),
    RESTORE_SNAPSHOT(ObjectType.CLUSTER),
    DELETE_SNAPSHOT(ObjectType.CLUSTER),
    CHECK_SNAPSHOT(ObjectType.CLUSTER),
    RESTORE_PITR(ObjectType.CLUSTER),
    CHECK_PITR(ObjectType.CLUSTER),
    CREATE_SEQUENCE(ObjectType.SEQUENCE),
    ALTER_SEQUENCE(ObjectType.SEQUENCE),
    USE_SEQUENCE(ObjectType.SEQUENCE),
    DROP_SEQUENCE(ObjectType.SEQUENCE),
    REVOKE_TOKEN(ObjectType.CLUSTER, true),
    ROLLING_UPGRADE(ObjectType.CLUSTER),
    MANAGE_CDC(ObjectType.CLUSTER);

    private final ObjectType applicableObjectType;
    private final boolean allowSelfAction;

    private Action(ObjectType applicableObjectType) {
        this.applicableObjectType = applicableObjectType;
        this.allowSelfAction = false;
    }

    private Action(ObjectType applicableObjectType, boolean allowSelfAction) {
        this.applicableObjectType = applicableObjectType;
        this.allowSelfAction = allowSelfAction;
    }

    public ObjectType applicableObjectType() {
        return this.applicableObjectType;
    }

    public boolean singleton() {
        return this.applicableObjectType == ObjectType.CLUSTER;
    }

    public boolean allowSelfAction() {
        return this.allowSelfAction;
    }
}

