/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.configuration.notifications.ConfigurationListener;
import org.apache.ignite3.internal.eventlog.api.EventLog;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.security.configuration.SecurityConfiguration;
import org.apache.ignite3.internal.security.configuration.SecurityView;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.rbac.assignments.RoleAssignmentImpl;
import org.gridgain.internal.rbac.assignments.RoleAssignmentManagement;
import org.gridgain.internal.rbac.assignments.RoleAssignmentManagementImpl;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.authorization.AuthorizerImpl;
import org.gridgain.internal.rbac.privileges.PrivilegeChecker;
import org.gridgain.internal.rbac.privileges.PrivilegeCheckerImpl;
import org.gridgain.internal.rbac.privileges.PrivilegeGrantsImpl;
import org.gridgain.internal.rbac.privileges.PrivilegeManagement;
import org.gridgain.internal.rbac.privileges.PrivilegeManagementImpl;
import org.gridgain.internal.rbac.roles.ConfigurationRoleStore;
import org.gridgain.internal.rbac.roles.RoleManagement;
import org.gridgain.internal.rbac.roles.RoleManagementImpl;
import org.gridgain.internal.rbac.users.ConfigurationUserStore;
import org.gridgain.internal.rbac.users.UserManagement;
import org.gridgain.internal.rbac.users.UserManagementImpl;
import org.jetbrains.annotations.Nullable;

public class Rbac
implements IgniteComponent {
    private final UserManagement userManagement;
    private final RoleManagementImpl roleManagement;
    private final RoleAssignmentManagement roleAssignmentManagement;
    private final PrivilegeManagementImpl privilegeManagement;
    private final PrivilegeChecker privilegeChecker;
    private final SecurityConfiguration securityConfiguration;
    private final Authorizer authorizer;
    private final AtomicBoolean securityConfigurationEnabled = new AtomicBoolean(false);
    private final AtomicBoolean rbacLicenseFeatureEnabled = new AtomicBoolean(false);
    private final ConfigurationListener<SecurityView> securityConfigurationListener = ctx -> {
        this.updateSecurityEnabled((SecurityView)ctx.newValue());
        return CompletableFutures.nullCompletedFuture();
    };

    public Rbac(Executor authenticationExecutor, SecurityConfiguration securityConfiguration, EventLog eventLog) {
        this.securityConfiguration = securityConfiguration;
        AuthorizerImpl authorizerImpl = new AuthorizerImpl(eventLog);
        ConfigurationRoleStore roleStore = new ConfigurationRoleStore(securityConfiguration.authorization());
        ConfigurationUserStore userStore = new ConfigurationUserStore(securityConfiguration.authentication());
        this.privilegeManagement = new PrivilegeManagementImpl(new PrivilegeGrantsImpl(roleStore), roleStore, authorizerImpl);
        this.privilegeChecker = new PrivilegeCheckerImpl(this.privilegeManagement);
        this.userManagement = new UserManagementImpl(authenticationExecutor, userStore, authorizerImpl);
        this.roleAssignmentManagement = new RoleAssignmentManagementImpl(new RoleAssignmentImpl(userStore, roleStore), userStore, roleStore, authorizerImpl);
        this.roleManagement = new RoleManagementImpl(roleStore, this.roleAssignmentManagement, authorizerImpl);
        authorizerImpl.init(this.privilegeChecker);
        this.authorizer = authorizerImpl;
    }

    public UserManagement userManagement() {
        return this.userManagement;
    }

    public RoleManagement roleManagement() {
        return this.roleManagement;
    }

    public RoleAssignmentManagement roleAssignmentManagement() {
        return this.roleAssignmentManagement;
    }

    public PrivilegeManagement privilegeManagement() {
        return this.privilegeManagement;
    }

    public PrivilegeChecker privilegeChecker() {
        return this.privilegeChecker;
    }

    public Authorizer authorizer() {
        return this.authorizer;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.securityConfiguration.listen(this.securityConfigurationListener);
        this.updateSecurityEnabled((SecurityView)this.securityConfiguration.value());
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.securityConfiguration.stopListen(this.securityConfigurationListener);
        return CompletableFutures.nullCompletedFuture();
    }

    private void updateSecurityEnabled(@Nullable SecurityView securityView) {
        this.securityConfigurationEnabled.set(securityView != null && securityView.enabled());
        this.updateAuthorizerEnabled();
    }

    public void enableRbacFeature(boolean enabled) {
        this.rbacLicenseFeatureEnabled.set(enabled);
        this.updateAuthorizerEnabled();
    }

    private void updateAuthorizerEnabled() {
        this.authorizer.enable(this.securityConfigurationEnabled.get() && this.rbacLicenseFeatureEnabled.get());
    }
}

