/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.metastorage;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.gridgain.internal.pitr.TableName;
import org.gridgain.internal.pitr.exception.PitrCancelledException;
import org.gridgain.internal.pitr.metastorage.PitrGlobalState;
import org.jetbrains.annotations.Nullable;

public class PitrStateContext {
    private static final VarHandle CANCELLATION_STATE;
    private final PitrGlobalState state;
    private final IgniteSpinBusyLock busyLock;
    private final long causalityToken;
    private final CompletableFuture<Void> completionFuture = new CompletableFuture();
    @Nullable
    private volatile CancellationState cancellationState;

    PitrStateContext(PitrGlobalState state, IgniteSpinBusyLock busyLock, long causalityToken) {
        this.state = state;
        this.busyLock = busyLock;
        this.causalityToken = causalityToken;
    }

    public UUID operationId() {
        return this.state().operationId();
    }

    public PitrGlobalState state() {
        return this.state;
    }

    public Set<TableName> tables() {
        return this.state().tables();
    }

    public long causalityToken() {
        return this.causalityToken;
    }

    void cancel() {
        CANCELLATION_STATE.compareAndSet(this, null, CancellationState.CANCELED);
    }

    void cancelByCoordinator() {
        CANCELLATION_STATE.compareAndSet(this, null, CancellationState.CANCELED_REMOTELY);
    }

    boolean isCanceled() {
        return this.cancellationState != null;
    }

    boolean isCancelledByCoordinator() {
        return this.cancellationState == CancellationState.CANCELED_REMOTELY;
    }

    void complete() {
        this.completionFuture.complete(null);
    }

    CompletableFuture<Void> completionFuture() {
        return this.completionFuture;
    }

    public <T> CompletableFuture<T> inBusyLockAsync(Supplier<CompletableFuture<T>> action) {
        if (this.isCanceled()) {
            return CompletableFuture.failedFuture(new PitrCancelledException());
        }
        return IgniteUtils.inBusyLockAsync(this.busyLock, action);
    }

    static {
        try {
            CANCELLATION_STATE = MethodHandles.lookup().findVarHandle(PitrStateContext.class, "cancellationState", CancellationState.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static enum CancellationState {
        CANCELED,
        CANCELED_REMOTELY;

    }
}

