/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.metastorage;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.gridgain.internal.pitr.metastorage.PitrProgressDetails;
import org.gridgain.internal.pitr.metastorage.PitrStatus;
import org.jetbrains.annotations.Nullable;

class PitrLocalState
implements Serializable {
    private static final long serialVersionUID = -5432848353687418345L;
    private PitrStatus status;
    private PitrProgressDetails total = PitrProgressDetails.DEFAULT;
    @IgniteToStringInclude
    private final Map<Integer, PitrProgressDetails> tables = new ConcurrentHashMap<Integer, PitrProgressDetails>();
    @Nullable
    private String description;

    PitrLocalState(PitrStatus status) {
        this.status = status;
    }

    public PitrStatus status() {
        return this.status;
    }

    public Map<Integer, PitrProgressDetails> tables() {
        return this.tables;
    }

    public PitrProgressDetails total() {
        return this.total;
    }

    long rowsUpdated(int tableId) {
        return this.tables.getOrDefault(tableId, PitrProgressDetails.DEFAULT).rowsUpdated();
    }

    long rowsUpdatedTotal() {
        return this.total.rowsUpdated();
    }

    @Nullable
    public String description() {
        return this.description;
    }

    void setDescription(@Nullable String description) {
        this.description = description;
    }

    void setStatus(PitrStatus status) {
        this.status = status;
    }

    public void setTotal(PitrProgressDetails total) {
        this.total = total;
    }

    public String toString() {
        return S.toString(PitrLocalState.class, this);
    }
}

