/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.message;

import java.util.Map;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.gridgain.internal.pitr.message.StateResponseMessage;
import org.gridgain.internal.pitr.message.StateResponseMessageBuilder;
import org.gridgain.internal.pitr.message.StateResponseMessageSerializer;
import org.gridgain.internal.pitr.metastorage.PitrStatus;

public class StateResponseMessageImpl
implements StateResponseMessage,
Cloneable {
    public static final short GROUP_TYPE = 1300;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private final String description;
    @IgniteToStringInclude
    private final Map<String, Long> progress;
    @IgniteToStringInclude
    private final PitrStatus status;

    private StateResponseMessageImpl(String description, Map<String, Long> progress, PitrStatus status) {
        this.description = description;
        this.progress = progress;
        this.status = status;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Map<String, Long> progress() {
        return this.progress;
    }

    @Override
    public PitrStatus status() {
        return this.status;
    }

    public MessageSerializer serializer() {
        return StateResponseMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 1300;
    }

    public String toString() {
        return S.toString(StateResponseMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        StateResponseMessageImpl otherMessage = (StateResponseMessageImpl)other;
        return Objects.equals(this.description, otherMessage.description) && Objects.equals(this.progress, otherMessage.progress) && Objects.equals((Object)this.status, (Object)otherMessage.status);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.description, this.progress, this.status});
        return result;
    }

    @Override
    public StateResponseMessageImpl clone() {
        try {
            return (StateResponseMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static StateResponseMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements StateResponseMessageBuilder {
        private String description;
        private Map<String, Long> progress;
        private PitrStatus status;

        private Builder() {
        }

        @Override
        public StateResponseMessageBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public StateResponseMessageBuilder progress(Map<String, Long> progress) {
            Objects.requireNonNull(progress, "progress is not marked @Nullable");
            this.progress = progress;
            return this;
        }

        @Override
        public StateResponseMessageBuilder status(PitrStatus status) {
            Objects.requireNonNull(status, "status is not marked @Nullable");
            this.status = status;
            return this;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public Map<String, Long> progress() {
            return this.progress;
        }

        @Override
        public PitrStatus status() {
            return this.status;
        }

        @Override
        public StateResponseMessage build() {
            return new StateResponseMessageImpl(this.description, Objects.requireNonNull(this.progress, "progress is not marked @Nullable"), Objects.requireNonNull(this.status, "status is not marked @Nullable"));
        }

        @Override
        public StateResponseMessage buildDeserialized() {
            return new StateResponseMessageImpl(this.description, this.progress, this.status);
        }
    }
}

