/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.gridgain.internal.pitr.message.StateRequestMessage;
import org.gridgain.internal.pitr.message.StateRequestMessageBuilder;
import org.gridgain.internal.pitr.message.StateRequestMessageSerializer;

public class StateRequestMessageImpl
implements StateRequestMessage,
Cloneable {
    public static final short GROUP_TYPE = 1300;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private final UUID operationId;

    private StateRequestMessageImpl(UUID operationId) {
        this.operationId = operationId;
    }

    @Override
    public UUID operationId() {
        return this.operationId;
    }

    public MessageSerializer serializer() {
        return StateRequestMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 1300;
    }

    public String toString() {
        return S.toString(StateRequestMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        StateRequestMessageImpl otherMessage = (StateRequestMessageImpl)other;
        return Objects.equals(this.operationId, otherMessage.operationId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.operationId);
        return result;
    }

    @Override
    public StateRequestMessageImpl clone() {
        try {
            return (StateRequestMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static StateRequestMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements StateRequestMessageBuilder {
        private UUID operationId;

        private Builder() {
        }

        @Override
        public StateRequestMessageBuilder operationId(UUID operationId) {
            Objects.requireNonNull(operationId, "operationId is not marked @Nullable");
            this.operationId = operationId;
            return this;
        }

        @Override
        public UUID operationId() {
            return this.operationId;
        }

        @Override
        public StateRequestMessage build() {
            return new StateRequestMessageImpl(Objects.requireNonNull(this.operationId, "operationId is not marked @Nullable"));
        }

        @Override
        public StateRequestMessage buildDeserialized() {
            return new StateRequestMessageImpl(this.operationId);
        }
    }
}

