/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.catalog;

import java.util.Collection;
import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.RenameTableCommand;
import org.apache.ignite3.internal.catalog.commands.RenameTableCommandBuilder;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.gridgain.internal.pitr.TableName;
import org.gridgain.internal.pitr.catalog.CommandState;

public class RenameTempTables
implements CatalogCommand {
    private final String prefix;
    private final Collection<TableName> tableNames;

    public RenameTempTables(String prefix, Collection<TableName> tableNames) {
        this.prefix = prefix;
        this.tableNames = tableNames;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CommandState commandState = new CommandState(catalog, updateContext.catalogService());
        for (TableName tableName : this.tableNames) {
            String schema = tableName.schema();
            String name = tableName.name();
            String tmpTableName = this.prefix + name;
            CatalogCommand renameCommand = ((RenameTableCommandBuilder)((RenameTableCommandBuilder)RenameTableCommand.builder().schemaName(schema)).tableName(tmpTableName)).newTableName(name).build();
            commandState.applyCommand(renameCommand);
        }
        return commandState.updateEntries();
    }
}

