/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.DropTableCommand;
import org.apache.ignite3.internal.catalog.commands.DropTableCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.gridgain.internal.pitr.TableName;
import org.gridgain.internal.pitr.catalog.CommandState;

public class DropExistingTablesCommand
implements CatalogCommand {
    private final Collection<TableName> tableNames;

    public DropExistingTablesCommand(Collection<TableName> tableNames) {
        this.tableNames = tableNames;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CommandState commandState = new CommandState(catalog, updateContext.catalogService());
        HashMap<String, List> schemaToTableNames = new HashMap<String, List>();
        for (TableName tableName : this.tableNames) {
            String schema = tableName.schema();
            String name = tableName.name();
            schemaToTableNames.computeIfAbsent(schema, k -> new ArrayList()).add(name);
        }
        for (Map.Entry entry : schemaToTableNames.entrySet()) {
            String schemaName = (String)entry.getKey();
            CatalogSchemaDescriptor schemaDescriptor = CatalogUtils.schemaOrThrow(catalog, schemaName);
            for (String tableName : (List)entry.getValue()) {
                CatalogTableDescriptor tableDescriptor = schemaDescriptor.table(tableName);
                if (tableDescriptor == null || tableDescriptor.cache()) continue;
                CatalogCommand dropTable = ((DropTableCommandBuilder)((DropTableCommandBuilder)DropTableCommand.builder().schemaName(schemaName)).tableName(tableName)).build();
                commandState.applyCommand(dropTable);
            }
        }
        return commandState.updateEntries();
    }
}

