/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr;

import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageServiceImpl;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.raft.Peer;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.pitr.PitrManager;
import org.gridgain.internal.pitr.PitrManagerContext;
import org.gridgain.internal.pitr.PitrState;
import org.gridgain.internal.pitr.exception.PitrException;
import org.gridgain.internal.pitr.message.ErrorResponseMessage;
import org.gridgain.internal.pitr.message.NotCoordinatorMessage;
import org.gridgain.internal.pitr.message.RecoveryRequestMessage;
import org.gridgain.internal.pitr.message.RecoveryResponseMessage;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.jetbrains.annotations.Nullable;

public class PitrFacade {
    private final PitrManagerContext context;
    private final PitrManager pitrManager;
    private final LicenseFeatureChecker licenseFeatureChecker;
    private final Authorizer authorizer;

    PitrFacade(PitrManagerContext context, PitrManager pitrManager, LicenseFeatureChecker licenseFeatureChecker, Authorizer authorizer) {
        this.context = context;
        this.pitrManager = pitrManager;
        this.licenseFeatureChecker = licenseFeatureChecker;
        this.authorizer = authorizer;
    }

    public CompletableFuture<UUID> recoverTables(@Nullable Instant timestamp, List<String> tables) {
        this.checkLicense();
        if (tables == null || tables.isEmpty()) {
            return CompletableFuture.failedFuture(new PitrException("Unable to start point in time recovery. No tables in request"));
        }
        long hybridTimestampLong = timestamp == null ? this.context.clock().nowLong() : HybridTimestamp.physicalToLong(timestamp.toEpochMilli());
        RecoveryRequestMessage request = this.context.messagesFactory().recoveryRequestMessage().timestampLong(hybridTimestampLong).tableNames(new HashSet<String>(tables)).build();
        return this.authorizer.authorizeThenCompose(Action.RESTORE_PITR, () -> this.sendToCoordinator(request)).thenApply(msg -> ((RecoveryResponseMessage)msg).operationId());
    }

    public CompletableFuture<PitrState> getRecoveryState(UUID operationId) {
        this.checkLicense();
        return this.authorizer.authorizeThenCompose(Action.CHECK_PITR, () -> this.pitrManager.getState(operationId));
    }

    private CompletableFuture<NetworkMessage> sendToCoordinator(NetworkMessage message) {
        return ((CompletableFuture)this.context.metaStorageManager().metaStorageService().thenApply(MetaStorageServiceImpl::raftGroupService)).thenCompose(raftService -> {
            Peer leader = raftService.leader();
            if (leader == null) {
                return raftService.refreshLeader().thenCompose(v -> this.sendToCoordinator(message));
            }
            return ((CompletableFuture)this.context.clusterService().messagingService().invoke(leader.consistentId(), message, 10000L).exceptionally(e -> {
                throw new PitrException("Unable to start point in time recovery: " + e.getMessage(), (Throwable)e);
            })).thenCompose(response -> {
                if (response instanceof RecoveryResponseMessage) {
                    return CompletableFuture.completedFuture(response);
                }
                if (response instanceof ErrorResponseMessage) {
                    return CompletableFuture.failedFuture(new PitrException(((ErrorResponseMessage)response).errorDescription()));
                }
                if (response instanceof NotCoordinatorMessage) {
                    return raftService.refreshLeader().thenCompose(v -> this.sendToCoordinator(message));
                }
                return CompletableFuture.failedFuture((Throwable)((Object)new AssertionError((Object)IgniteStringFormatter.format("Unexpected response {}", response.getClass()))));
            });
        });
    }

    private void checkLicense() {
        if (this.licenseFeatureChecker != null) {
            this.licenseFeatureChecker.checkFeature(LicenseFeature.POINT_IN_TIME_RECOVERY);
        }
    }
}

