/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.storage.BinaryRowAndRowId;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.gridgain.internal.recovery.TableDataProvider;

class MvPartitionDataProvider
implements TableDataProvider {
    private final TableViewInternal table;
    private final HybridTimestamp tsUpperBound;
    private final InternalClusterNode thisNode;
    private final InternalTransaction transaction;

    MvPartitionDataProvider(TableViewInternal table, HybridTimestamp tsUpperBound, InternalClusterNode thisNode, InternalTransaction transaction) {
        this.table = table;
        this.tsUpperBound = tsUpperBound;
        this.thisNode = thisNode;
        this.transaction = transaction;
    }

    @Override
    public Flow.Publisher<BinaryRowAndRowId> partitionDataAsync(int partitionId, ExecutorService executorService) {
        MvPartitionStorage partition = this.table.internalTable().storage().getMvPartition(partitionId);
        assert (partition != null) : "Missing partition storage: " + partitionId;
        return this.table.internalTable().scanInterval(partitionId, this.transaction.id(), HybridTimestamp.MIN_VALUE, this.tsUpperBound, this.thisNode, this.transaction.coordinatorId());
    }
}

