/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr;

import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.gridgain.internal.pitr.RebalanceWatch;
import org.gridgain.internal.pitr.metastorage.PitrLocalStateWatch;

public class CoordinatorState {
    private final long term;
    private final ConcurrentMap<UUID, PitrLocalStateWatch> ongoingOperations;
    private final RebalanceWatch rebalanceWatch;

    CoordinatorState(long term, ConcurrentMap<UUID, PitrLocalStateWatch> ongoingOperations, RebalanceWatch rebalanceWatch) {
        this.term = term;
        this.ongoingOperations = ongoingOperations;
        this.rebalanceWatch = rebalanceWatch;
    }

    public long term() {
        return this.term;
    }

    RebalanceWatch rebalanceWatch() {
        return this.rebalanceWatch;
    }

    public void onOperationStarted(UUID operationId, PitrLocalStateWatch localStateWatch) {
        this.ongoingOperations.put(operationId, localStateWatch);
    }

    public void onOperationComplete(UUID operationId) {
        this.ongoingOperations.remove(operationId);
        this.rebalanceWatch.removeOperation(operationId);
    }

    boolean hasOngoingOperation(UUID operationId) {
        return this.ongoingOperations.containsKey(operationId);
    }
}

