/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import org.apache.ignite3.internal.util.StringUtils;
import org.gridgain.internal.license.HoconLicense;
import org.gridgain.internal.license.License;
import org.gridgain.internal.license.LicenseViolationException;
import org.jetbrains.annotations.Nullable;

public class LicenseWithSignature {
    private static final String SIGNATURE_PATH = "signatures.signature_1";
    private static final String DEPRECATED_HOCON_LICENSE_SIGNATURE_PATH = "signature";
    private final License license;
    private final String signature;

    private LicenseWithSignature(License license, @Nullable String signature) {
        this.license = license;
        this.signature = signature;
    }

    License license() {
        return this.license;
    }

    @Nullable
    String signature() {
        return this.signature;
    }

    static LicenseWithSignature parseLicense(String licenseString) {
        if (StringUtils.nullOrBlank(licenseString)) {
            throw new LicenseViolationException("License parsing error: license is empty");
        }
        Config cfg = ConfigFactory.parseString((String)licenseString);
        String content = cfg.withoutPath("signatures").root().render(ConfigRenderOptions.concise());
        HoconLicense license = new HoconLicense(content, true);
        String signature = cfg.hasPath(SIGNATURE_PATH) ? cfg.getString(SIGNATURE_PATH) : null;
        return new LicenseWithSignature(license, signature);
    }

    public static LicenseWithSignature parseLicense(Config licenseCfg) {
        String content = LicenseWithSignature.getLicenseContent(licenseCfg);
        String signature = LicenseWithSignature.getLicenseSignature(licenseCfg);
        boolean isJson = !LicenseWithSignature.isDeprecatedHoconLicense(licenseCfg);
        HoconLicense license = new HoconLicense(content, isJson);
        return new LicenseWithSignature(license, signature);
    }

    static LicenseWithSignature parseLicense(String content, String signature) {
        if (signature != null && !signature.isEmpty()) {
            return new LicenseWithSignature(new HoconLicense(content, false), signature);
        }
        return LicenseWithSignature.parseLicense(content);
    }

    public static LicenseWithSignature fromLicense(License license) {
        return new LicenseWithSignature(license, null);
    }

    private static String getLicenseSignature(Config licenseCfg) {
        if (LicenseWithSignature.isDeprecatedHoconLicense(licenseCfg)) {
            return licenseCfg.getString(DEPRECATED_HOCON_LICENSE_SIGNATURE_PATH);
        }
        return ConfigFactory.parseString((String)licenseCfg.getString("content")).getString(SIGNATURE_PATH);
    }

    private static String getLicenseContent(Config licenseCfg) {
        if (licenseCfg.hasPath("content")) {
            Config cfg = ConfigFactory.parseString((String)licenseCfg.getString("content"));
            return LicenseWithSignature.getLicenseContentWithoutSignature(cfg);
        }
        return LicenseWithSignature.getLicenseContentWithoutSignature(licenseCfg);
    }

    private static String getLicenseContentWithoutSignature(Config licenseCfg) {
        return licenseCfg.withoutPath("signatures").root().render(ConfigRenderOptions.concise());
    }

    private static boolean isDeprecatedHoconLicense(Config licenseCfg) {
        return licenseCfg.hasPath(DEPRECATED_HOCON_LICENSE_SIGNATURE_PATH);
    }
}

