/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.properties.IgniteProductVersion;
import org.apache.ignite3.internal.util.StringUtils;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.gridgain.internal.license.HoconLicense;
import org.gridgain.internal.license.HoconLicenseField;
import org.gridgain.internal.license.InvalidBlockedLicenseListException;
import org.gridgain.internal.license.InvalidSignatureException;
import org.gridgain.internal.license.License;
import org.gridgain.internal.license.LicenseLimitChecker;
import org.gridgain.internal.license.LicenseViolationException;
import org.gridgain.internal.license.LicenseViolationInfo;
import org.gridgain.internal.license.LicenseWithSignature;
import org.jetbrains.annotations.Nullable;

class LicenseValidator {
    private static final IgniteLogger LOG = Loggers.forClass(LicenseValidator.class);
    private static final String BLOCKED_LICENSES_FILE_NAME = "blocked-licenses.conf";
    private static final Set<String> blockedLicenses = LicenseValidator.readBlockedLicensesFromResources("blocked-licenses.conf");

    LicenseValidator() {
    }

    static LicenseViolationInfo verifyLicense(LicenseWithSignature licenseWithSignature) {
        LicenseViolationInfo violationInfo = new LicenseViolationInfo();
        License license = licenseWithSignature.license();
        LicenseValidator.verifyContent(license, violationInfo);
        if (license instanceof HoconLicense) {
            LicenseValidator.verifySignature(license, licenseWithSignature.signature(), violationInfo);
        }
        return violationInfo;
    }

    static LicenseViolationInfo verifyLicense(LicenseWithSignature licenseWithSignature, Collection<LogicalNode> nodes) {
        LicenseViolationInfo violationInfo = LicenseValidator.verifyLicense(licenseWithSignature);
        LicenseLimitChecker.checkAll(licenseWithSignature.license(), violationInfo, nodes);
        return violationInfo;
    }

    static LicenseViolationInfo verifyLicenseViolation(License license, Collection<LogicalNode> nodes) {
        LicenseViolationInfo violationInfo = new LicenseViolationInfo();
        LicenseLimitChecker.checkAll(license, violationInfo, nodes);
        return violationInfo;
    }

    static Set<String> readBlockedLicensesFromResources(String fileName) {
        try {
            Config blockedLicenses = ConfigFactory.parseResources((String)fileName);
            if (blockedLicenses.isEmpty()) {
                throw new InvalidBlockedLicenseListException("Missing blocked licenses list");
            }
            Config rawContent = blockedLicenses.getConfig("banned-licenses.content");
            HoconLicense content = new HoconLicense(rawContent);
            String signature = blockedLicenses.getString("banned-licenses.signature");
            LicenseViolationInfo violationInfo = new LicenseViolationInfo();
            LicenseValidator.verifySignature(content, signature, violationInfo);
            if (violationInfo.hasViolations()) {
                throw new InvalidSignatureException("The blocked licenses list is invalid or has been tampered with");
            }
            IgniteProductVersion version = IgniteProductVersion.fromString(rawContent.getString(IgniteNameUtils.quote("gridgain.version")));
            List ids = rawContent.getStringList("ids");
            if (!IgniteProductVersion.CURRENT_VERSION.equals(version)) {
                throw new InvalidBlockedLicenseListException("Blocked licenses list version mismatch [expectedVer=" + IgniteProductVersion.CURRENT_VERSION + ", actualVer=" + version + "]");
            }
            return Set.copyOf(ids);
        }
        catch (InvalidBlockedLicenseListException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidBlockedLicenseListException("The blocked licenses list is invalid or has been changed", (Throwable)e);
        }
    }

    private static boolean isBlockedLicense(String licenseId) throws LicenseViolationException {
        return blockedLicenses.contains(licenseId);
    }

    private static void verifyContent(License license, LicenseViolationInfo violationInfo) {
        String id = license.field(HoconLicenseField.ID);
        if (id == null) {
            violationInfo.addViolation("licenseId", null, "License has no identifier field");
        }
        if (id != null && LicenseValidator.isBlockedLicense(id)) {
            violationInfo.addViolation("licenseId", null, "The license is blocked and can't be used: " + id);
        }
        LocalDate startDate = license.field(HoconLicenseField.START_DATE);
        LocalDate expireDate = license.field(HoconLicenseField.EXPIRE_DATE);
        if (startDate == null) {
            violationInfo.addViolation("startDate", null, "License has no valid start date");
        }
        if (expireDate == null) {
            violationInfo.addViolation("expireDate", null, "License has no valid expiration date");
        }
        LocalDate currentDate = LocalDate.now();
        if (startDate != null && currentDate.isBefore(startDate)) {
            violationInfo.addViolation("startDate", startDate, currentDate, "License has not started yet");
        }
        if (expireDate != null && currentDate.isAfter(expireDate)) {
            violationInfo.addViolation("expireDate", expireDate, currentDate, "License is expired");
        }
    }

    private static void verifySignature(License license, @Nullable String digitalSignature, LicenseViolationInfo violationInfo) {
        if (StringUtils.nullOrBlank(digitalSignature)) {
            violationInfo.addViolation("signature", digitalSignature, "License signature is missing from the cluster configuration");
            return;
        }
        if ((digitalSignature.length() & 1) != 0) {
            violationInfo.addViolation("signature", digitalSignature, "License signature length should be even");
            return;
        }
        if (!LicenseValidator.isHexadecimal(digitalSignature)) {
            violationInfo.addViolation("signature", digitalSignature, "License signature should be a hexadecimal string");
            return;
        }
        try {
            if (!license.verifySignature(StringUtils.fromHexString(digitalSignature))) {
                violationInfo.addViolation("signature", digitalSignature, "The license is invalid or has been tampered with");
            }
        }
        catch (InvalidSignatureException e) {
            LOG.error("Unable to verify license signature", (Throwable)e);
            violationInfo.addViolation("signature", digitalSignature, "The license is invalid or has been tampered with");
        }
    }

    private static boolean isHexadecimal(String str) {
        return str.chars().noneMatch(c -> Character.digit(c, 16) == -1);
    }
}

