/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.eviction.task;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.EvictionView;
import org.gridgain.internal.eviction.task.EvictionRunner;
import org.gridgain.internal.eviction.task.EvictionTask;
import org.gridgain.internal.eviction.task.LowWatermarkUpdater;

public class RandomTask
implements EvictionTask {
    private final ScheduledExecutorService executorService;
    private final LowWatermarkUpdater lowWatermarkUpdater;
    private final EvictionView evictionView;
    private final EvictionRunner evictionRunner;
    private final ClockService clockService;
    private ScheduledFuture lwmUpdaterFuture;
    private ScheduledFuture evictionRunnerFuture;
    private final String regionName;

    RandomTask(String regionName, ScheduledExecutorService executorService, LowWatermarkUpdater lowWatermarkUpdater, EvictionView evictionView, EvictionRunner evictionRunner, ClockService clockService) {
        this.regionName = regionName;
        this.executorService = executorService;
        this.lowWatermarkUpdater = lowWatermarkUpdater;
        this.evictionRunner = evictionRunner;
        this.clockService = clockService;
        this.evictionView = evictionView;
    }

    @Override
    public void cancel() {
        if (this.lwmUpdaterFuture != null) {
            this.lwmUpdaterFuture.cancel(true);
        }
        if (this.evictionRunnerFuture != null) {
            this.evictionRunnerFuture.cancel(true);
        }
    }

    @Override
    public void run() {
        this.lwmUpdaterFuture = this.executorService.scheduleAtFixedRate(() -> {
            HybridTimestamp lwm = this.lowWatermarkUpdater.updateLowWatermark();
            if (this.evictionRunnerFuture == null && this.evictionCanBeStarted(lwm)) {
                this.evictionRunnerFuture = this.executorService.scheduleAtFixedRate(() -> this.evictionRunner.evict(this.regionName, this.evictionView.batchSize()), 0L, this.evictionView.interval(), TimeUnit.MILLISECONDS);
            }
        }, 0L, this.evictionView.lwmUpdateInterval(), TimeUnit.MILLISECONDS);
    }

    private boolean evictionCanBeStarted(HybridTimestamp lwm) {
        return this.clockService.now().getPhysical() - lwm.getPhysical() < this.evictionView.lwmThreshold();
    }
}

