/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.eviction.task;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gridgain.internal.eviction.task.EvictionTask;
import org.gridgain.internal.eviction.task.LowWatermarkUpdater;

class HistoryOnlyTask
implements EvictionTask {
    private final ScheduledExecutorService executorService;
    private final LowWatermarkUpdater lowWatermarkUpdater;
    private final long lwmUpdateInterval;
    private ScheduledFuture scheduledFuture;

    HistoryOnlyTask(ScheduledExecutorService executorService, LowWatermarkUpdater lowWatermarkUpdater, long lwmUpdateInterval) {
        this.executorService = executorService;
        this.lowWatermarkUpdater = lowWatermarkUpdater;
        this.lwmUpdateInterval = lwmUpdateInterval;
    }

    @Override
    public void cancel() {
        this.scheduledFuture.cancel(true);
    }

    @Override
    public void run() {
        this.scheduledFuture = this.executorService.scheduleAtFixedRate(this.lowWatermarkUpdater::updateLowWatermark, 0L, this.lwmUpdateInterval, TimeUnit.MILLISECONDS);
    }
}

