/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.eviction;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.placementdriver.PlacementDriver;
import org.apache.ignite3.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite3.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.util.CompletableFutures;

public class PrimaryReplicaProvider {
    private final TopologyService topologyService;
    private final NodeProperties nodeProperties;
    private final Map<Integer, Set<TablePartitionId>> currentNodeTablePrimaryReplicas = new ConcurrentHashMap<Integer, Set<TablePartitionId>>();
    private final Map<Integer, Set<ZonePartitionId>> currentNodeZonePrimaryReplicas = new ConcurrentHashMap<Integer, Set<ZonePartitionId>>();

    public PrimaryReplicaProvider(PlacementDriver placementDriver, TopologyService topologyService, NodeProperties nodeProperties) {
        this.topologyService = topologyService;
        this.nodeProperties = nodeProperties;
        placementDriver.listen(PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, this::monitorPartition);
        placementDriver.listen(PrimaryReplicaEvent.PRIMARY_REPLICA_EXPIRED, this::stopMonitorPartition);
    }

    private CompletableFuture<Boolean> monitorPartition(PrimaryReplicaEventParameters primaryReplicaEventParameters) {
        if (!primaryReplicaEventParameters.leaseholderId().equals(this.topologyService.localMember().id())) {
            return CompletableFutures.falseCompletedFuture();
        }
        ReplicationGroupId partitionKey = primaryReplicaEventParameters.groupId();
        if (this.nodeProperties.colocationEnabled()) {
            this.monitorPartition((ZonePartitionId)partitionKey);
        } else if (partitionKey instanceof TablePartitionId) {
            this.monitorPartition((TablePartitionId)partitionKey);
        }
        return CompletableFutures.falseCompletedFuture();
    }

    private void monitorPartition(TablePartitionId partitionKey) {
        this.currentNodeTablePrimaryReplicas.computeIfAbsent(partitionKey.tableId(), x -> ConcurrentHashMap.newKeySet()).add(partitionKey);
    }

    private void monitorPartition(ZonePartitionId partitionKey) {
        this.currentNodeZonePrimaryReplicas.computeIfAbsent(partitionKey.zoneId(), x -> ConcurrentHashMap.newKeySet()).add(partitionKey);
    }

    private CompletableFuture<Boolean> stopMonitorPartition(PrimaryReplicaEventParameters primaryReplicaEventParameters) {
        ReplicationGroupId partitionKey = primaryReplicaEventParameters.groupId();
        if (this.nodeProperties.colocationEnabled()) {
            this.stopMonitorPartition((ZonePartitionId)partitionKey);
        } else if (partitionKey instanceof TablePartitionId) {
            this.stopMonitorPartition((TablePartitionId)partitionKey);
        }
        return CompletableFutures.falseCompletedFuture();
    }

    private void stopMonitorPartition(TablePartitionId partitionKey) {
        this.currentNodeTablePrimaryReplicas.computeIfPresent(partitionKey.tableId(), (k, v) -> {
            v.remove(partitionKey);
            if (v.isEmpty()) {
                return null;
            }
            return v;
        });
    }

    private void stopMonitorPartition(ZonePartitionId partitionKey) {
        this.currentNodeZonePrimaryReplicas.computeIfPresent(partitionKey.zoneId(), (k, v) -> {
            v.remove(partitionKey);
            if (v.isEmpty()) {
                return null;
            }
            return v;
        });
    }

    public List<Integer> getPartitionsByTableId(int tableId) {
        return this.currentNodeTablePrimaryReplicas.getOrDefault(tableId, Set.of()).stream().map(TablePartitionId::partitionId).collect(Collectors.toList());
    }

    public List<Integer> getPartitionsByZoneId(int zoneId) {
        return this.currentNodeZonePrimaryReplicas.getOrDefault(zoneId, Set.of()).stream().map(ZonePartitionId::partitionId).collect(Collectors.toList());
    }
}

