/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.eviction;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.storage.pagememory.VolatilePageMemoryStorageEngine;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.eviction.EvictionScannerTask;
import org.gridgain.internal.eviction.EvictionTaskWrapper;
import org.gridgain.internal.eviction.configuration.EvictionConfiguration;
import org.gridgain.internal.eviction.task.EvictionTaskFactory;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.jetbrains.annotations.TestOnly;

public class EvictionManager
implements IgniteComponent {
    private final Map<String, EvictionTaskWrapper> evictionTasks = new ConcurrentHashMap<String, EvictionTaskWrapper>();
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final EvictionConfiguration evictionConfiguration;
    private final VolatilePageMemoryStorageEngine storageEngine;
    private final EvictionTaskFactory evictionTaskFactory;
    private final LicenseFeatureChecker licenseChecker;
    private final FailureProcessor failureProcessor;

    public EvictionManager(String nodeName, EvictionConfiguration evictionConfiguration, VolatilePageMemoryStorageEngine storageEngine, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, EvictionTaskFactory evictionTaskFactory, LicenseFeatureChecker licenseChecker, FailureProcessor failureProcessor) {
        this.evictionConfiguration = evictionConfiguration;
        this.storageEngine = storageEngine;
        this.executorService = executorService;
        this.scheduledExecutorService = scheduledExecutorService;
        this.evictionTaskFactory = evictionTaskFactory;
        this.licenseChecker = licenseChecker;
        this.failureProcessor = failureProcessor;
    }

    @TestOnly
    boolean isEvictionRunning() {
        return this.evictionTasks.values().stream().anyMatch(x -> !x.isCancelled());
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        EvictionScannerTask evictionScannerTask = new EvictionScannerTask(this.executorService, this.evictionTasks, this.storageEngine, this.evictionTaskFactory, this.licenseChecker, this.failureProcessor);
        this.scheduledExecutorService.scheduleWithFixedDelay(evictionScannerTask, 0L, (Long)this.evictionConfiguration.checkInterval().value(), TimeUnit.MILLISECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }
}

