/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.validator;

import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;
import org.apache.ignite3.internal.util.OperatingSystem;
import org.gridgain.internal.encryption.validator.RequiresEncryptionSupport;

public class RequiresEncryptionSupportValidatorImpl
implements Validator<RequiresEncryptionSupport, Boolean> {
    public static final RequiresEncryptionSupportValidatorImpl INSTANCE = new RequiresEncryptionSupportValidatorImpl();

    @Override
    public void validate(RequiresEncryptionSupport annotation, ValidationContext<Boolean> ctx) {
        boolean enabled = ctx.getNewValue();
        if (enabled && !RequiresEncryptionSupportValidatorImpl.isEncryptionSupported()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Encryption is not supported on your platform. Currently, it is only available on Linux."));
        }
    }

    public static boolean isEncryptionSupported() {
        return OperatingSystem.current() == OperatingSystem.LINUX;
    }
}

