/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.storage;

import java.util.Collections;
import java.util.Map;
import org.gridgain.internal.encryption.storage.KeyChain;
import org.jetbrains.annotations.Nullable;

public interface KeyStorage {
    @Nullable
    public KeyChain getKeyChain(String var1);

    public Map<String, KeyChain> getKeyChains();

    public void store(String var1, KeyChain var2);

    public void storeAll(Map<String, KeyChain> var1);

    public void remove(String var1);

    public static class NoopKeyStorage
    implements KeyStorage {
        public static final KeyStorage INSTANCE = new NoopKeyStorage();

        private NoopKeyStorage() {
        }

        @Override
        @Nullable
        public KeyChain getKeyChain(String id) {
            return null;
        }

        @Override
        public Map<String, KeyChain> getKeyChains() {
            return Collections.emptyMap();
        }

        @Override
        public void store(String id, KeyChain keyChain) {
        }

        @Override
        public void storeAll(Map<String, KeyChain> keyChains) {
        }

        @Override
        public void remove(String id) {
        }
    }
}

