/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gridgain.internal.dcr.AuthConfig;
import org.gridgain.internal.dcr.ReplicationStatus;
import org.gridgain.internal.dcr.SslConfig;
import org.gridgain.internal.dcr.metastorage.ReplicationEntry;
import org.jetbrains.annotations.Nullable;

public class ReplicationStartOptions {
    private final String name;
    private final Set<String> sourceClusterAddresses;
    @Nullable
    private final AuthConfig authConfig;
    @Nullable
    private final SslConfig sslConfig;
    private final String schema;
    @Nullable
    private final Instant flushPoint;
    private final boolean allTables;
    private final List<String> tables;
    private final Set<String> replicationNodes;

    private ReplicationStartOptions(String name, Set<String> sourceClusterAddresses, @Nullable AuthConfig authConfig, @Nullable SslConfig sslConfig, String schema, @Nullable Instant flushPoint, boolean allTables, List<String> tables, Set<String> replicationNodes) {
        this.name = name;
        this.sourceClusterAddresses = sourceClusterAddresses;
        this.authConfig = authConfig;
        this.sslConfig = sslConfig;
        this.schema = schema;
        this.flushPoint = flushPoint;
        this.allTables = allTables;
        this.tables = tables;
        this.replicationNodes = replicationNodes;
    }

    public String name() {
        return this.name;
    }

    public Set<String> sourceClusterAddresses() {
        return this.sourceClusterAddresses;
    }

    @Nullable
    public AuthConfig authConfig() {
        return this.authConfig;
    }

    @Nullable
    public SslConfig sslConfig() {
        return this.sslConfig;
    }

    public String schema() {
        return this.schema;
    }

    public boolean allTables() {
        return this.allTables;
    }

    public List<String> tables() {
        return this.tables;
    }

    @Nullable
    public Instant flushPoint() {
        return this.flushPoint;
    }

    public Set<String> replicationNodes() {
        return this.replicationNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationStartOptions that = (ReplicationStartOptions)o;
        return this.allTables == that.allTables && Objects.equals(this.sourceClusterAddresses, that.sourceClusterAddresses) && Objects.equals(this.authConfig, that.authConfig) && Objects.equals(this.sslConfig, that.sslConfig) && Objects.equals(this.schema, that.schema) && Objects.equals(this.flushPoint, that.flushPoint) && Objects.equals(this.tables, that.tables) && Objects.equals(this.replicationNodes, that.replicationNodes);
    }

    public int hashCode() {
        return Objects.hash(this.sourceClusterAddresses, this.authConfig, this.sslConfig, this.schema, this.flushPoint, this.allTables, this.tables, this.replicationNodes);
    }

    public static ReplicationStartOptions fromEntry(ReplicationEntry entry) {
        return ReplicationStartOptions.builder().sourceClusterAddresses(entry.sourceClusterAddresses()).authConfig(AuthConfig.fromEntry(entry.authConfig())).sslConfig(SslConfig.fromEntry(entry.sslConfig())).tables(entry.tableStatuses().entrySet().stream().filter(e -> e.getValue() == ReplicationStatus.REPLICATING).map(Map.Entry::getKey).collect(Collectors.toList())).schema(entry.schema()).flushPoint(entry.flushPoint()).build();
    }

    public static ReplicationOptionsBuilder builder() {
        return new ReplicationOptionsBuilder();
    }

    public static class ReplicationOptionsBuilder {
        private String name;
        private Set<String> sourceClusterAddresses;
        @Nullable
        private AuthConfig authConfig;
        @Nullable
        private SslConfig sslConfig;
        private boolean allTables = false;
        private final List<String> tables = new ArrayList<String>();
        @Nullable
        private Instant flushPoint;
        private String schema;
        private final Set<String> replicationNodes = new HashSet<String>();

        public ReplicationOptionsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ReplicationOptionsBuilder sourceClusterAddresses(Set<String> sourceClusterAddresses) {
            this.sourceClusterAddresses = sourceClusterAddresses;
            return this;
        }

        public ReplicationOptionsBuilder authConfig(@Nullable AuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public ReplicationOptionsBuilder sslConfig(@Nullable SslConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public ReplicationOptionsBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public ReplicationOptionsBuilder flushPoint(@Nullable Instant flushPoint) {
            this.flushPoint = flushPoint;
            return this;
        }

        public ReplicationOptionsBuilder allTables(boolean allTables) {
            this.allTables = allTables;
            return this;
        }

        public ReplicationOptionsBuilder tables(Collection<String> tables) {
            this.tables.addAll(tables);
            return this;
        }

        public ReplicationOptionsBuilder replicationNodes(@Nullable Set<String> replicationNodes) {
            this.replicationNodes.clear();
            if (replicationNodes != null) {
                this.replicationNodes.addAll(replicationNodes);
            }
            return this;
        }

        public ReplicationStartOptions build() {
            Objects.requireNonNull(this.sourceClusterAddresses, "Source cluster address must not be null.");
            Objects.requireNonNull(this.schema, "Schema must not be null.");
            if (!this.allTables && this.tables.isEmpty()) {
                throw new IllegalArgumentException("Replication must have at least one table.");
            }
            for (String table : this.tables) {
                Objects.requireNonNull(table, "Table must not be null.");
            }
            return new ReplicationStartOptions(this.name, this.sourceClusterAddresses, this.authConfig, this.sslConfig, this.schema, this.flushPoint, this.allTables, this.tables, this.replicationNodes);
        }
    }
}

