/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.user.role;

import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.rbac.assignments.AssignRevokeCallInput;
import org.gridgain.internal.cli.call.rbac.assignments.AssignRoleCall;
import picocli.CommandLine;

@CommandLine.Command(name="assign", description={"Assign role to user"})
public class UserRoleAssignCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Option(names={"--to"}, description={"To username"}, required=true, split=",")
    private List<String> username;
    @CommandLine.Option(names={"--role", "-r"}, description={"Role name"}, required=true, split=",")
    private List<String> roleName;
    @Inject
    private AssignRoleCall assignRoleCall;

    @Override
    public Integer call() {
        return this.runPipeline(CallExecutionPipeline.builder(this.assignRoleCall).inputProvider(() -> AssignRevokeCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).roleNames(this.roleName).usernames(this.username).build()).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot assign role")));
    }
}

