/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.upgrade.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.FlowBuilder;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.apache.ignite3.internal.cli.core.style.component.QuestionUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import org.gridgain.internal.cli.call.upgrade.UpgradeStartCall;
import org.gridgain.internal.cli.call.upgrade.UpgradeStartCallInput;
import picocli.CommandLine;

@CommandLine.Command(name="start", description={"Start rolling upgrade process."})
public class UpgradeStartReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--version"}, description={"New version. For example, 9.1.1"}, required=true)
    private String version;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private UpgradeStartCall upgradeStartCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).then(UpgradeStartReplCommand.askQuestionBeforeUpgradeStart().build()).map(url -> new UpgradeStartCallInput((String)url, this.version)).then(Flows.fromCall(this.upgradeStartCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot start upgrade")).print());
    }

    private static FlowBuilder<String, String> askQuestionBeforeUpgradeStart() {
        QuestionUiComponent questionUiComponent = QuestionUiComponent.fromYesNoQuestion("Upgrade cannot be canceled once started. Do you want to continue?", new UiElement[0]);
        return Flows.acceptQuestion(questionUiComponent, clusterUrl -> clusterUrl);
    }
}

